/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis.distance;

public class DistanceComputer {
    public static final int ABSOLUTE_VALUE_DISTANCE = 1;
    public static final int EUCLIDEAN_DISTANCE = 2;
    public static final int NORMALIZED_EUCLIDEAN_DISTANCE = 3;
    public static final int MAHALANOBIS_DISTANCE = 4;

    public static double getAbsoluteValueDistance(double[] x, double[] y) {
        assert (x.length == y.length);
        double dist = 0.0;
        int i = 0;
        while (i < x.length) {
            dist += Math.abs(x[i] - y[i]);
            ++i;
        }
        return dist;
    }

    public static double getEuclideanDistance(double[] x, double[] y) {
        assert (x.length == y.length);
        double dist = 0.0;
        int i = 0;
        while (i < x.length) {
            dist += (x[i] - y[i]) * (x[i] - y[i]);
            ++i;
        }
        dist = Math.sqrt(dist);
        return dist;
    }

    public static double getNormalizedEuclideanDistance(double[] x, double[] y, double[] variances) {
        assert (x.length == y.length);
        assert (x.length == variances.length);
        double dist = 0.0;
        int i = 0;
        while (i < x.length) {
            dist += (x[i] - y[i]) * (x[i] - y[i]) / variances[i];
            ++i;
        }
        dist = Math.sqrt(dist);
        return dist;
    }

    public static double getLsfInverseHarmonicDistance(double[] lsfs1, double[] lsfs2, double freqRange) {
        assert (lsfs1.length == lsfs2.length);
        double[] lsfWeights = DistanceComputer.getLsfWeights(lsfs1, freqRange);
        double dist = 0.0;
        int i = 0;
        while (i < lsfs1.length) {
            dist += lsfWeights[i] * Math.abs(lsfs1[i] - lsfs2[i]);
            ++i;
        }
        return dist;
    }

    public static double getLsfInverseHarmonicDistanceSymmetric(double[] lsfs1, double[] lsfs2, double alpha, double freqRange) {
        assert (lsfs1.length == lsfs2.length);
        double[] lsfWeights1 = DistanceComputer.getLsfWeights(lsfs1, freqRange);
        double[] lsfWeights2 = DistanceComputer.getLsfWeights(lsfs2, freqRange);
        double dist = 0.0;
        double oneMinusAlpha = 1.0 - alpha;
        int i = 0;
        while (i < lsfs1.length) {
            double absVal = Math.abs(lsfs1[i] - lsfs2[i]);
            dist += oneMinusAlpha * lsfWeights1[i] * absVal + alpha * lsfWeights2[i] * absVal;
            ++i;
        }
        return dist;
    }

    public static double[] getLsfWeights(double[] lsfs, double freqRange) {
        double[] lsfWeights = new double[lsfs.length];
        lsfWeights[0] = 1.0 / Math.abs(lsfs[1] - lsfs[0]);
        int i = 1;
        while (i < lsfWeights.length - 1) {
            lsfWeights[i] = 1.0 / Math.min(Math.abs(lsfs[i] - lsfs[i - 1]), Math.abs(lsfs[i + 1] - lsfs[i]));
            ++i;
        }
        lsfWeights[lsfWeights.length - 1] = 1.0 / Math.abs(lsfs[lsfWeights.length - 1] - lsfs[lsfWeights.length - 2]);
        double tempSum = 0.0;
        double centerFreq = 0.0;
        i = 0;
        while (i < lsfs.length) {
            centerFreq += lsfs[i] * lsfWeights[i];
            tempSum += lsfWeights[i];
            ++i;
        }
        double lowerFreq = Math.max(0.0, (centerFreq /= tempSum) - 0.5 * freqRange);
        double upperFreq = lowerFreq + freqRange;
        i = 0;
        while (i < lsfs.length) {
            if (lsfs[i] < lowerFreq || lsfs[i] > upperFreq) {
                lsfWeights[i] = 0.0;
            }
            ++i;
        }
        return lsfWeights;
    }

    public static double getMahalanobisDistance(double[] x, double[] mean, double[][] inverseCovarianceMatrix) {
        assert (x.length == mean.length);
        assert (x.length == inverseCovarianceMatrix.length);
        double dist = 0.0;
        int i = 0;
        while (i < x.length) {
            double tmpDist = 0.0;
            int j = 0;
            while (j < x.length) {
                tmpDist += (x[j] - mean[j]) * inverseCovarianceMatrix[j][i];
                ++j;
            }
            dist += tmpDist * (x[i] - mean[i]);
            ++i;
        }
        dist = Math.sqrt(dist);
        return dist;
    }
}

