/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis.distance;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.analysis.LpcAnalyser;
import marytts.signalproc.analysis.LsfAnalyser;
import marytts.signalproc.window.HammingWindow;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.signal.SignalProcUtils;

public class SpectralDistanceMeasures {
    public static double MAX_SPECTRAL_DISTANCE = 1.0E10;

    public static double lsfDist(double[] speechFrame1, double[] speechFrame2, int samplingRate) {
        return SpectralDistanceMeasures.lsfDist(speechFrame1, speechFrame2, samplingRate, SignalProcUtils.getLPOrder(samplingRate));
    }

    public static double lsfDist(double[] speechFrame1, double[] speechFrame2, int samplingRate, int lpOrder) {
        double[] windowedSpeechFrame1 = new double[speechFrame1.length];
        System.arraycopy(speechFrame1, 0, windowedSpeechFrame1, 0, speechFrame1.length);
        windowedSpeechFrame1 = SignalProcUtils.applyPreemphasis(windowedSpeechFrame1, 0.97);
        double[] windowedSpeechFrame2 = new double[speechFrame2.length];
        System.arraycopy(speechFrame2, 0, windowedSpeechFrame2, 0, speechFrame2.length);
        windowedSpeechFrame2 = SignalProcUtils.applyPreemphasis(windowedSpeechFrame2, 0.97);
        HammingWindow w1 = new HammingWindow(speechFrame1.length);
        w1.apply(windowedSpeechFrame1, 0);
        HammingWindow w2 = new HammingWindow(speechFrame2.length);
        w2.apply(windowedSpeechFrame2, 0);
        LpcAnalyser.LpCoeffs lpcs1 = LpcAnalyser.calcLPC(windowedSpeechFrame1, lpOrder);
        LpcAnalyser.LpCoeffs lpcs2 = LpcAnalyser.calcLPC(windowedSpeechFrame2, lpOrder);
        double[] lsfs1 = LsfAnalyser.lpc2lsfInHz(lpcs1.getOneMinusA(), samplingRate);
        double[] lsfs2 = LsfAnalyser.lpc2lsfInHz(lpcs2.getOneMinusA(), samplingRate);
        return SpectralDistanceMeasures.getLsfDist(lsfs1, lsfs2, samplingRate);
    }

    public static double getLsfDist(double[] lsfs1, double[] lsfs2, int samplingRate) {
        double[] lsfWgt = SpectralDistanceMeasures.getInverseHarmonicLSFWeights(lsfs1);
        return SpectralDistanceMeasures.getLsfDist(lsfs1, lsfs2, samplingRate, lsfWgt);
    }

    public static double getLsfDist(double[] lsfs1, double[] lsfs2, int samplingRate, double[] lsfWgt) {
        assert (lsfs1.length == lsfs2.length);
        assert (lsfs1.length == lsfWgt.length);
        double dist = 0.0;
        int i = 0;
        while (i < lsfs1.length) {
            dist += 0.1 * lsfWgt[i] * Math.abs(lsfs1[i] - lsfs2[i]);
            ++i;
        }
        dist = dist * 16000.0 / (double)samplingRate;
        dist = Math.min(20.0, dist / (double)lsfs1.length);
        dist = 10.0 * (dist + 1.0E-36);
        return dist;
    }

    public static double[] getInverseHarmonicLSFWeights(double[] lsfs) {
        assert (lsfs.length > 1);
        int P = lsfs.length;
        double[] lsfWgt = new double[P];
        lsfWgt[0] = 1.0 / Math.abs(lsfs[1] - lsfs[0]);
        lsfWgt[P - 1] = 0.5 / Math.abs(lsfs[P - 1] - lsfs[P - 2]);
        int i = 1;
        while (i <= P - 2) {
            lsfWgt[i] = 1.0 / Math.min(Math.abs(lsfs[i] - lsfs[i - 1]), Math.abs(lsfs[i + 1] - lsfs[i]));
            ++i;
        }
        double tmp = 0.0;
        i = 0;
        while (i < P) {
            lsfWgt[i] = Math.exp(-0.05 * (double)i) * lsfWgt[i];
            tmp += lsfWgt[i];
            ++i;
        }
        i = 0;
        while (i < P) {
            int n = i++;
            lsfWgt[n] = lsfWgt[n] / tmp;
        }
        tmp = 0.0;
        i = 0;
        while (i <= P - 1) {
            lsfWgt[i] = Math.sqrt(lsfWgt[i]);
            tmp += lsfWgt[i];
            ++i;
        }
        i = 0;
        while (i < P) {
            int n = i++;
            lsfWgt[n] = lsfWgt[n] / tmp;
        }
        return lsfWgt;
    }

    public static double rmsLogSpectralDist(double[] speechFrame1, double[] speechFrame2, int fftSize, int lpOrder) {
        double[] windowedSpeechFrame1 = new double[speechFrame1.length];
        System.arraycopy(speechFrame1, 0, windowedSpeechFrame1, 0, speechFrame1.length);
        double[] windowedSpeechFrame2 = new double[speechFrame2.length];
        System.arraycopy(speechFrame2, 0, windowedSpeechFrame2, 0, speechFrame2.length);
        HammingWindow w1 = new HammingWindow(speechFrame1.length);
        w1.apply(windowedSpeechFrame1, 0);
        HammingWindow w2 = new HammingWindow(speechFrame2.length);
        w2.apply(windowedSpeechFrame2, 0);
        double[] Xabs1 = LpcAnalyser.calcSpecFrameLinear(speechFrame1, lpOrder, fftSize);
        double[] Xabs2 = LpcAnalyser.calcSpecFrameLinear(speechFrame2, lpOrder, fftSize);
        double dist = 0.0;
        int w = 0;
        while (w < Xabs1.length) {
            dist += 10.0 * Math.log10(Xabs1[w] * Xabs1[w]) - 10.0 * Math.log10(Xabs2[w] * Xabs2[w]);
            ++w;
        }
        return Math.min(dist, MAX_SPECTRAL_DISTANCE);
    }

    public static double kullbackLeiblerSpectralDist(double[] speechFrame1, double[] speechFrame2, int fftSize, int lpOrder) {
        double[] windowedSpeechFrame1 = new double[speechFrame1.length];
        System.arraycopy(speechFrame1, 0, windowedSpeechFrame1, 0, speechFrame1.length);
        double[] windowedSpeechFrame2 = new double[speechFrame2.length];
        System.arraycopy(speechFrame2, 0, windowedSpeechFrame2, 0, speechFrame2.length);
        HammingWindow w1 = new HammingWindow(speechFrame1.length);
        w1.apply(windowedSpeechFrame1, 0);
        HammingWindow w2 = new HammingWindow(speechFrame2.length);
        w2.apply(windowedSpeechFrame2, 0);
        double[] Xabs1 = LpcAnalyser.calcSpecFrameLinear(speechFrame1, lpOrder, fftSize);
        double[] Xabs2 = LpcAnalyser.calcSpecFrameLinear(speechFrame2, lpOrder, fftSize);
        double klDist = 0.0;
        int w = 0;
        while (w < Xabs1.length) {
            klDist += Xabs1[w] * Math.log(Xabs1[w] / (Xabs2[w] + 1.0E-20) + 1.0E-20);
            ++w;
        }
        return Math.min(klDist, MAX_SPECTRAL_DISTANCE);
    }

    public static double kullbackLeiblerSymmetricSpectralDist(double[] speechFrame1, double[] speechFrame2, int fftSize, int lpOrder) {
        double[] windowedSpeechFrame1 = new double[speechFrame1.length];
        System.arraycopy(speechFrame1, 0, windowedSpeechFrame1, 0, speechFrame1.length);
        double[] windowedSpeechFrame2 = new double[speechFrame2.length];
        System.arraycopy(speechFrame2, 0, windowedSpeechFrame2, 0, speechFrame2.length);
        HammingWindow w1 = new HammingWindow(speechFrame1.length);
        w1.apply(windowedSpeechFrame1, 0);
        HammingWindow w2 = new HammingWindow(speechFrame2.length);
        w2.apply(windowedSpeechFrame2, 0);
        double[] Xabs1 = LpcAnalyser.calcSpecFrameLinear(speechFrame1, lpOrder, fftSize);
        double[] Xabs2 = LpcAnalyser.calcSpecFrameLinear(speechFrame2, lpOrder, fftSize);
        double klDist12 = 0.0;
        double klDist21 = 0.0;
        int w = 0;
        while (w < Xabs1.length) {
            klDist12 += Xabs1[w] * Math.log(Xabs1[w] / (Xabs2[w] + 1.0E-20) + 1.0E-20);
            ++w;
        }
        w = 0;
        while (w < Xabs2.length) {
            klDist21 += Xabs2[w] * Math.log(Xabs2[w] / (Xabs1[w] + 1.0E-20) + 1.0E-20);
            ++w;
        }
        return Math.min(0.5 * (klDist12 + klDist21), MAX_SPECTRAL_DISTANCE);
    }

    public static double itakuraSaitoDistSymmetric(double[] speechFrame1, double[] speechFrame2, int fftSize, int lpOrder) {
        return 0.5 * SpectralDistanceMeasures.itakuraSaitoDist(speechFrame1, speechFrame2, fftSize, lpOrder) + 0.5 * SpectralDistanceMeasures.itakuraSaitoDist(speechFrame2, speechFrame1, fftSize, lpOrder);
    }

    public static double itakuraSaitoDist(double[] speechFrame1, double[] speechFrame2, int fftSize, int lpOrder) {
        double[] preemphasizedFrame1 = SignalProcUtils.applyPreemphasis(speechFrame1, 0.97);
        double[] preemphasizedFrame2 = SignalProcUtils.applyPreemphasis(speechFrame2, 0.97);
        double[] windowedSpeechFrame1 = new double[preemphasizedFrame1.length];
        System.arraycopy(preemphasizedFrame1, 0, windowedSpeechFrame1, 0, preemphasizedFrame1.length);
        double[] windowedSpeechFrame2 = new double[preemphasizedFrame2.length];
        System.arraycopy(preemphasizedFrame2, 0, windowedSpeechFrame2, 0, preemphasizedFrame2.length);
        HammingWindow w1 = new HammingWindow(speechFrame1.length);
        w1.apply(windowedSpeechFrame1, 0);
        HammingWindow w2 = new HammingWindow(speechFrame2.length);
        w2.apply(windowedSpeechFrame2, 0);
        double[] Xabs1 = LpcAnalyser.calcSpecFrameLinear(speechFrame1, lpOrder, fftSize);
        double[] Xabs2 = LpcAnalyser.calcSpecFrameLinear(speechFrame2, lpOrder, fftSize);
        double dist = 0.0;
        int w = 0;
        while (w < Xabs1.length) {
            Xabs1[w] = Xabs1[w] * Xabs1[w];
            ++w;
        }
        w = 0;
        while (w < Xabs2.length) {
            Xabs2[w] = Xabs2[w] * Xabs2[w];
            ++w;
        }
        w = 0;
        while (w < Xabs1.length) {
            dist += Xabs1[w] / Math.max(Xabs2[w], 1.0E-20) - Math.log(Math.max(Xabs1[w], 1.0E-20)) + Math.log(Math.max(Xabs2[w], 1.0E-20)) - 1.0;
            ++w;
        }
        return Math.min(dist, MAX_SPECTRAL_DISTANCE);
    }

    public static double coshDist(double[] speechFrame1, double[] speechFrame2, int fftSize, int lpOrder) {
        double[] preemphasizedFrame1 = SignalProcUtils.applyPreemphasis(speechFrame1, 0.97);
        double[] preemphasizedFrame2 = SignalProcUtils.applyPreemphasis(speechFrame2, 0.97);
        double[] windowedSpeechFrame1 = new double[preemphasizedFrame1.length];
        System.arraycopy(preemphasizedFrame1, 0, windowedSpeechFrame1, 0, preemphasizedFrame1.length);
        double[] windowedSpeechFrame2 = new double[preemphasizedFrame2.length];
        System.arraycopy(preemphasizedFrame2, 0, windowedSpeechFrame2, 0, preemphasizedFrame2.length);
        HammingWindow w1 = new HammingWindow(speechFrame1.length);
        w1.apply(windowedSpeechFrame1, 0);
        HammingWindow w2 = new HammingWindow(speechFrame2.length);
        w2.apply(windowedSpeechFrame2, 0);
        double[] Xabs1 = LpcAnalyser.calcSpecFrameLinear(speechFrame1, lpOrder, fftSize);
        double[] Xabs2 = LpcAnalyser.calcSpecFrameLinear(speechFrame2, lpOrder, fftSize);
        double dist12 = 0.0;
        double dist21 = 0.0;
        int w = 0;
        while (w < Xabs1.length) {
            Xabs1[w] = Xabs1[w] * Xabs1[w];
            ++w;
        }
        w = 0;
        while (w < Xabs2.length) {
            Xabs2[w] = Xabs2[w] * Xabs2[w];
            ++w;
        }
        w = 0;
        while (w < Xabs1.length) {
            dist12 += Xabs1[w] / (Xabs2[w] + 1.0E-20) - Math.log(Xabs1[w] / (Xabs2[w] + 1.0E-20) + 1.0E-20) - 1.0;
            ++w;
        }
        w = 0;
        while (w < Xabs2.length) {
            dist21 += Xabs2[w] / (Xabs1[w] + 1.0E-20) - Math.log(Xabs2[w] / (Xabs1[w] + 1.0E-20) + 1.0E-20) - 1.0;
            ++w;
        }
        return Math.min(0.5 * (dist12 + dist21), MAX_SPECTRAL_DISTANCE);
    }

    public static void main(String[] args) {
        AudioInputStream inputAudio = null;
        try {
            inputAudio = AudioSystem.getAudioInputStream(new File(args[0]));
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (inputAudio != null) {
            int samplingRate = (int)inputAudio.getFormat().getSampleRate();
            int ws = (int)((double)samplingRate * 0.02);
            int ss = (int)((double)samplingRate * 0.01);
            AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
            double[] x = signal.getAllData();
            int numfrm = (int)(((double)x.length - (double)ws) / (double)ss - 2.0);
            double[] frm1 = new double[ws];
            double[] frm2 = new double[ws];
            int i = 0;
            while (i < numfrm) {
                System.arraycopy(x, i * ss, frm1, 0, ws);
                System.arraycopy(x, (i + 1) * ss, frm2, 0, ws);
                double lsfDist = SpectralDistanceMeasures.lsfDist(frm1, frm2, samplingRate);
                System.out.println("Distance between frame " + String.valueOf(i + 1) + " and frame " + String.valueOf(i + 2) + " = " + String.valueOf(lsfDist));
                ++i;
            }
        }
    }
}

