/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.filter;

import java.io.File;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.display.FunctionGraph;
import marytts.signalproc.display.MultiDisplay;
import marytts.signalproc.filter.FIRFilter;
import marytts.signalproc.filter.HighPassFilter;
import marytts.signalproc.filter.LowPassFilter;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.math.FFT;
import marytts.util.math.MathUtils;

public class BandRejectFilter
extends FIRFilter {
    public static double DEFAULT_TRANSITIONBANDWIDTH = 0.01;
    public double lowerNormalisedCutoffFrequency;
    public double upperNormalisedCutoffFrequency;

    public BandRejectFilter(double lowerNormalisedCutoffFrequencyIn, double upperNormalisedCutoffFrequencyIn) {
        this(lowerNormalisedCutoffFrequencyIn, upperNormalisedCutoffFrequencyIn, DEFAULT_TRANSITIONBANDWIDTH);
    }

    public BandRejectFilter(double lowerNormalisedCutoffFrequencyIn, double upperNormalisedCutoffFrequencyIn, double normalisedTransitionBandwidth) {
        this(lowerNormalisedCutoffFrequencyIn, upperNormalisedCutoffFrequencyIn, BandRejectFilter.bandwidth2kernelLength(normalisedTransitionBandwidth));
    }

    public BandRejectFilter(double lowerNormalisedCutoffFrequencyIn, double upperNormalisedCutoffFrequencyIn, int kernelLength) {
        if (kernelLength <= 0 || kernelLength % 2 == 0) {
            throw new IllegalArgumentException("Kernel length must be an odd positive number, got " + kernelLength);
        }
        this.lowerNormalisedCutoffFrequency = lowerNormalisedCutoffFrequencyIn;
        this.upperNormalisedCutoffFrequency = upperNormalisedCutoffFrequencyIn;
        if (this.lowerNormalisedCutoffFrequency <= 0.0 || this.lowerNormalisedCutoffFrequency >= 0.5 || this.upperNormalisedCutoffFrequency <= 0.0 || this.upperNormalisedCutoffFrequency >= 0.5) {
            throw new IllegalArgumentException("Normalised cutoff frequencies must be between 0 and 0.5, got " + this.lowerNormalisedCutoffFrequency + " and " + this.upperNormalisedCutoffFrequency);
        }
        double[] kernel = BandRejectFilter.getKernel(this.lowerNormalisedCutoffFrequency, this.upperNormalisedCutoffFrequency, kernelLength);
        this.sliceLength = MathUtils.closestPowerOfTwoAbove(2 * kernelLength) - kernelLength;
        this.initialise(kernel, this.sliceLength);
    }

    public double getTransitionBandWidth(int samplingRate) {
        return (double)samplingRate * BandRejectFilter.kernelLength2bandwidth(this.impulseResponseLength);
    }

    protected static double[] getKernel(double lowerNormalisedCutoffFrequencyIn, double upperNormalisedCutoffFrequencyIn, int kernelLength) {
        double[] lowPassKernel = LowPassFilter.getKernel(lowerNormalisedCutoffFrequencyIn, kernelLength);
        double[] highPassKernel = HighPassFilter.getKernel(upperNormalisedCutoffFrequencyIn, kernelLength);
        double[] kernel = new double[kernelLength];
        int i = 0;
        while (i < kernelLength) {
            kernel[i] = lowPassKernel[i] + highPassKernel[i];
            ++i;
        }
        return kernel;
    }

    protected static int bandwidth2kernelLength(double normalisedTransitionBandwidth) {
        int l = (int)(4.0 / normalisedTransitionBandwidth);
        if (l % 2 == 0) {
            ++l;
        }
        return l;
    }

    protected static double kernelLength2bandwidth(int kernelLength) {
        return 4.0 / (double)kernelLength;
    }

    public String toString() {
        return "Band reject filter";
    }

    public static void main(String[] args) throws Exception {
        int lowerCutoffFreq = Integer.valueOf(args[0]);
        int upperCutoffFreq = Integer.valueOf(args[1]);
        AudioDoubleDataSource source = new AudioDoubleDataSource(AudioSystem.getAudioInputStream(new File(args[2])));
        int samplingRate = source.getSamplingRate();
        double lowerNormalisedCutoffFrequency = (double)lowerCutoffFreq / (double)samplingRate;
        double upperNormalisedCutoffFrequency = (double)upperCutoffFreq / (double)samplingRate;
        BandRejectFilter filter = new BandRejectFilter(lowerNormalisedCutoffFrequency, upperNormalisedCutoffFrequency, 40.0 / (double)samplingRate);
        System.err.println("Created " + filter.toString() + " with reject band from " + lowerCutoffFreq + " Hz to " + upperCutoffFreq + " Hz and transition band width " + (int)filter.getTransitionBandWidth(samplingRate) + " Hz");
        DoubleDataSource filteredSignal = filter.apply(source);
        if (args.length >= 4) {
            File outputFile = new File(args[3]);
            AudioSystem.write((AudioInputStream)new DDSAudioInputStream(filteredSignal, source.getAudioFormat()), AudioFileFormat.Type.WAVE, outputFile);
        } else {
            double[] fftSignal = new double[filter.transformedIR.length];
            System.arraycopy(filter.transformedIR, 0, fftSignal, 0, filter.transformedIR.length);
            FFT.realTransform(fftSignal, true);
            double[] kernel = new double[filter.impulseResponseLength];
            System.arraycopy(fftSignal, 0, kernel, 0, kernel.length);
            FunctionGraph timeGraph = new FunctionGraph(0.0, 1.0, kernel);
            timeGraph.showInJFrame(String.valueOf(filter.toString()) + " in time domain", true, false);
            double[] powerSpectrum = FFT.computePowerSpectrum_FD(filter.transformedIR);
            int i = 0;
            while (i < powerSpectrum.length) {
                powerSpectrum[i] = MathUtils.db(powerSpectrum[i]);
                ++i;
            }
            FunctionGraph freqGraph = new FunctionGraph(0.0, (double)samplingRate / (double)filter.transformedIR.length, powerSpectrum);
            freqGraph.showInJFrame(String.valueOf(filter.toString()) + " log frequency response", true, false);
            new MultiDisplay(filteredSignal.getAllData(), samplingRate, String.valueOf(filter.toString()) + " (" + lowerCutoffFreq + "->" + upperCutoffFreq + "Hz) applied to " + args[2], 800, 600);
        }
    }
}

