/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.filter;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.filter.LowPassFilter;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.signal.SignalProcUtils;

public class ComplementaryFilterBankChannelAnalyser {
    public double[] lpfOut;
    public double[] hpfOut;
    public double[] lpfOutInterpolated;
    public double lpfOutEnergy;
    protected LowPassFilter Hd;
    protected LowPassFilter Hb;
    protected LowPassFilter Hi;
    protected int filterLengthMinusOne;
    protected double[] filterNumerator;

    public ComplementaryFilterBankChannelAnalyser(int N) {
        if (N % 2 != 0) {
            ++N;
        }
        this.filterLengthMinusOne = N;
        this.Hd = new LowPassFilter(0.25, this.filterLengthMinusOne + 1);
        this.Hb = new LowPassFilter(0.475, (int)(0.5 * (double)this.filterLengthMinusOne + 1.0));
        this.Hi = new LowPassFilter(0.25, this.filterLengthMinusOne + 1);
        this.filterNumerator = new double[1];
        this.filterNumerator[0] = 1.0;
    }

    public double[] applyToOutputHighComponent(double[] x) {
        this.apply(x);
        return this.hpfOut;
    }

    public double[] applyToOutputLowComponent(double[] x) {
        this.apply(x);
        return this.lpfOut;
    }

    public double[] applyToOutputLowInterpolatedComponent(double[] x) {
        this.apply(x);
        return this.lpfOutInterpolated;
    }

    public void apply(double[] x) {
        double[] lpfOutTmp = this.Hd.apply(x);
        lpfOutTmp = SignalProcUtils.decimate(lpfOutTmp, 2.0);
        lpfOutTmp = this.Hb.apply(lpfOutTmp);
        this.lpfOutInterpolated = SignalProcUtils.interpolate(lpfOutTmp, 2.0);
        this.lpfOutInterpolated = this.Hi.apply(this.lpfOutInterpolated);
        double enx = SignalProcUtils.energy(x);
        double enxloi = SignalProcUtils.energy(this.lpfOutInterpolated);
        double gxloi = Math.sqrt(enx / enxloi);
        int i = 0;
        while (i < this.lpfOutInterpolated.length) {
            int n = i++;
            this.lpfOutInterpolated[n] = this.lpfOutInterpolated[n] * gxloi;
        }
        int delay = (int)Math.floor(1.5 * (double)this.filterLengthMinusOne + 0.5) - 1;
        this.hpfOut = new double[x.length];
        i = 0;
        while (i < x.length - delay) {
            this.hpfOut[i] = x[i] - this.lpfOutInterpolated[i + delay];
            ++i;
        }
        i = x.length - delay;
        while (i < x.length) {
            this.hpfOut[i] = 0.0;
            ++i;
        }
        delay = (int)Math.floor(0.5 * (double)this.filterLengthMinusOne + 0.5);
        this.lpfOut = new double[lpfOutTmp.length - delay];
        i = delay;
        while (i < lpfOutTmp.length) {
            this.lpfOut[i - delay] = lpfOutTmp[i];
            ++i;
        }
        this.lpfOutEnergy = SignalProcUtils.energy(this.lpfOut);
    }

    public static void main(String[] args) throws UnsupportedAudioFileException, IOException {
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[0]));
        inputAudio.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
        double[] x = signal.getAllData();
        int N = 512;
        ComplementaryFilterBankChannelAnalyser channel = new ComplementaryFilterBankChannelAnalyser(N);
        channel.apply(x);
        AudioFormat loFormat = new AudioFormat(inputAudio.getFormat().getSampleRate() * 0.5f, inputAudio.getFormat().getSampleSizeInBits(), inputAudio.getFormat().getChannels(), true, true);
        DDSAudioInputStream outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(channel.lpfOut), loFormat);
        String outFileName = String.valueOf(args[0].substring(0, args[0].length() - 4)) + "_lo.wav";
        AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outFileName));
        AudioFormat loiFormat = new AudioFormat(inputAudio.getFormat().getSampleRate(), inputAudio.getFormat().getSampleSizeInBits(), inputAudio.getFormat().getChannels(), true, true);
        outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(channel.lpfOutInterpolated), loiFormat);
        outFileName = String.valueOf(args[0].substring(0, args[0].length() - 4)) + "_loi.wav";
        AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outFileName));
        outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(channel.hpfOut), inputAudio.getFormat());
        outFileName = String.valueOf(args[0].substring(0, args[0].length() - 4)) + "_hi.wav";
        AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outFileName));
    }
}

