/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.filter;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.filter.BandPassFilter;
import marytts.signalproc.filter.FIRFilter;
import marytts.signalproc.filter.FilterBankAnalyserBase;
import marytts.signalproc.filter.HighPassFilter;
import marytts.signalproc.filter.LowPassFilter;
import marytts.signalproc.filter.Subband;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.signal.SignalProcUtils;

public class FIRBandPassFilterBankAnalyser
extends FilterBankAnalyserBase {
    public static final double OVERLAP_AROUND_1000HZ_DEFAULT = 100.0;
    public double overlapAround1000Hz;
    public int samplingRateInHz;
    public FIRFilter[] filters;
    public double[] normalizationFilterTransformedIR;
    public double[] lowerCutOffsInHz;
    public double[] upperCutOffsInHz;

    public FIRBandPassFilterBankAnalyser(int numBands, int samplingRateInHz) {
        this(numBands, samplingRateInHz, 100.0);
    }

    public FIRBandPassFilterBankAnalyser(int numBands, int samplingRateInHzIn, double overlapAround1000HzIn) {
        this.samplingRateInHz = samplingRateInHzIn;
        double halfSamplingRate = 0.5 * (double)this.samplingRateInHz;
        this.lowerCutOffsInHz = new double[numBands];
        this.upperCutOffsInHz = new double[numBands];
        this.overlapAround1000Hz = overlapAround1000HzIn;
        int i = 0;
        while (i < numBands) {
            this.upperCutOffsInHz[i] = i < numBands - 1 ? (double)this.samplingRateInHz / Math.pow(2.0, numBands - i) : halfSamplingRate;
            this.lowerCutOffsInHz[i] = i == 0 ? 0.0 : this.upperCutOffsInHz[i - 1];
            double overlapInHz = 0.5 * (this.upperCutOffsInHz[i] + this.lowerCutOffsInHz[i]) / (1000.0 / this.overlapAround1000Hz);
            if (i > 0) {
                int n = i;
                this.lowerCutOffsInHz[n] = this.lowerCutOffsInHz[n] - overlapInHz;
            }
            if (i < numBands - 1) {
                int n = i;
                this.upperCutOffsInHz[n] = this.upperCutOffsInHz[n] + overlapInHz;
            }
            System.out.println("Subband #" + String.valueOf(i + 1) + " - Lower cutoff: " + String.valueOf(this.lowerCutOffsInHz[i]) + " Upper cutoff: " + String.valueOf(this.upperCutOffsInHz[i]));
            ++i;
        }
        this.initialise(this.lowerCutOffsInHz, this.upperCutOffsInHz, overlapAround1000HzIn);
    }

    public FIRBandPassFilterBankAnalyser(double[] lowerCutOffsInHzIn, double[] upperCutOffsInHzIn, int samplingRateInHzIn) {
        this(lowerCutOffsInHzIn, upperCutOffsInHzIn, samplingRateInHzIn, 100.0);
    }

    public FIRBandPassFilterBankAnalyser(double[] lowerCutOffsInHzIn, double[] upperCutOffsInHzIn, int samplingRateInHzIn, double overlapAround1000HzIn) {
        this.samplingRateInHz = samplingRateInHzIn;
        this.initialise(lowerCutOffsInHzIn, upperCutOffsInHzIn, overlapAround1000HzIn);
    }

    public void initialise(double[] lowerCutOffsInHzIn, double[] upperCutOffsInHzIn, double overlapAround1000HzIn) {
        this.normalizationFilterTransformedIR = null;
        if (lowerCutOffsInHzIn != null && upperCutOffsInHzIn != null) {
            int j;
            assert (lowerCutOffsInHzIn.length == upperCutOffsInHzIn.length);
            this.lowerCutOffsInHz = new double[lowerCutOffsInHzIn.length];
            this.upperCutOffsInHz = new double[upperCutOffsInHzIn.length];
            System.arraycopy(lowerCutOffsInHzIn, 0, this.lowerCutOffsInHz, 0, lowerCutOffsInHzIn.length);
            System.arraycopy(upperCutOffsInHzIn, 0, this.upperCutOffsInHz, 0, upperCutOffsInHzIn.length);
            this.filters = new FIRFilter[this.lowerCutOffsInHz.length];
            int filterOrder = SignalProcUtils.getFIRFilterOrder(this.samplingRateInHz);
            this.overlapAround1000Hz = overlapAround1000HzIn;
            int i = 0;
            while (i < this.lowerCutOffsInHz.length) {
                assert (this.lowerCutOffsInHz[i] < this.upperCutOffsInHz[i]);
                ++i;
            }
            i = 0;
            while (i < this.lowerCutOffsInHz.length) {
                double normalizedLowerCutoff;
                double normalizedUpperCutoff;
                if (this.lowerCutOffsInHz[i] <= 0.0) {
                    normalizedUpperCutoff = Math.min(this.upperCutOffsInHz[i] / (double)this.samplingRateInHz, 0.5);
                    normalizedUpperCutoff = Math.max(normalizedUpperCutoff, 0.0);
                    this.filters[i] = new LowPassFilter(normalizedUpperCutoff, filterOrder);
                } else if (this.upperCutOffsInHz[i] >= 0.5 * (double)this.samplingRateInHz) {
                    normalizedLowerCutoff = Math.max(this.lowerCutOffsInHz[i] / (double)this.samplingRateInHz, 0.0);
                    normalizedLowerCutoff = Math.min(normalizedLowerCutoff, 0.5);
                    this.filters[i] = new HighPassFilter(normalizedLowerCutoff, filterOrder);
                } else {
                    normalizedLowerCutoff = Math.max(this.lowerCutOffsInHz[i] / (double)this.samplingRateInHz, 0.0);
                    normalizedLowerCutoff = Math.min(normalizedLowerCutoff, 0.5);
                    normalizedUpperCutoff = Math.min(this.upperCutOffsInHz[i] / (double)this.samplingRateInHz, 0.5);
                    normalizedUpperCutoff = Math.max(normalizedUpperCutoff, 0.0);
                    assert (normalizedLowerCutoff < normalizedUpperCutoff);
                    this.filters[i] = new BandPassFilter(normalizedLowerCutoff, normalizedUpperCutoff, filterOrder);
                }
                ++i;
            }
            int maxFreq = this.filters[0].transformedIR.length / 2 + 1;
            this.normalizationFilterTransformedIR = new double[maxFreq];
            Arrays.fill(this.normalizationFilterTransformedIR, 0.0);
            i = 0;
            while (i < this.filters.length) {
                this.normalizationFilterTransformedIR[0] = this.normalizationFilterTransformedIR[0] + Math.abs(this.filters[i].transformedIR[0]);
                int n = maxFreq - 1;
                this.normalizationFilterTransformedIR[n] = this.normalizationFilterTransformedIR[n] + Math.abs(this.filters[i].transformedIR[1]);
                j = 1;
                while (j < maxFreq - 1) {
                    int n2 = j;
                    this.normalizationFilterTransformedIR[n2] = this.normalizationFilterTransformedIR[n2] + Math.sqrt(this.filters[i].transformedIR[2 * j] * this.filters[i].transformedIR[2 * j] + this.filters[i].transformedIR[2 * j + 1] * this.filters[i].transformedIR[2 * j + 1]);
                    ++j;
                }
                ++i;
            }
            j = 0;
            while (j < maxFreq) {
                this.normalizationFilterTransformedIR[j] = 1.0 / this.normalizationFilterTransformedIR[j];
                ++j;
            }
        }
    }

    @Override
    public Subband[] apply(double[] x) {
        Subband[] subbands = null;
        if (this.filters != null && x != null) {
            subbands = new Subband[this.filters.length];
            int i = 0;
            while (i < this.filters.length) {
                if (this.filters[i] instanceof LowPassFilter) {
                    subbands[i] = new Subband(this.filters[i].apply(x), this.samplingRateInHz, 0.0, ((LowPassFilter)this.filters[i]).normalisedCutoffFrequency * (double)this.samplingRateInHz);
                } else if (this.filters[i] instanceof HighPassFilter) {
                    subbands[i] = new Subband(this.filters[i].apply(x), this.samplingRateInHz, ((HighPassFilter)this.filters[i]).normalisedCutoffFrequency * (double)this.samplingRateInHz, 0.5 * (double)this.samplingRateInHz);
                } else if (this.filters[i] instanceof BandPassFilter) {
                    subbands[i] = new Subband(this.filters[i].apply(x), this.samplingRateInHz, ((BandPassFilter)this.filters[i]).lowerNormalisedCutoffFrequency * (double)this.samplingRateInHz, ((BandPassFilter)this.filters[i]).upperNormalisedCutoffFrequency * (double)this.samplingRateInHz);
                }
                ++i;
            }
        }
        return subbands;
    }

    public static void main(String[] args) throws UnsupportedAudioFileException, IOException {
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[0]));
        int samplingRate = (int)inputAudio.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
        double[] x = signal.getAllData();
        int numBands = 4;
        double overlapAround1000Hz = 100.0;
        FIRBandPassFilterBankAnalyser analyser = new FIRBandPassFilterBankAnalyser(numBands, samplingRate, overlapAround1000Hz);
        Subband[] subbands = analyser.apply(x);
        int i = 0;
        while (i < subbands.length) {
            AudioFormat outputFormat = new AudioFormat((int)subbands[i].samplingRate, inputAudio.getFormat().getSampleSizeInBits(), inputAudio.getFormat().getChannels(), true, true);
            DDSAudioInputStream outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(subbands[i].waveform), outputFormat);
            String outFileName = String.valueOf(args[0].substring(0, args[0].length() - 4)) + "_band" + String.valueOf(i + 1) + ".wav";
            AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outFileName));
            ++i;
        }
    }
}

