/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.filter;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.filter.FIRWaveletFilterBankAnalyser;
import marytts.signalproc.filter.Subband;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.signal.SignalProcUtils;

public class FIRWaveletFilterBankSynthesiser {
    public double[] apply(FIRWaveletFilterBankAnalyser analyser, Subband[] subbands, boolean bNormalizeInOverlappingRegions) {
        double[] x = null;
        double[] lowBandIntFilt = null;
        double[] highBandIntFilt = null;
        if (analyser != null && analyser.filters != null && subbands != null) {
            int i = subbands.length - 2;
            while (i >= 0) {
                lowBandIntFilt = i == subbands.length - 2 ? SignalProcUtils.interpolate(subbands[i + 1].waveform, 2.0) : SignalProcUtils.interpolate(x, 2.0);
                lowBandIntFilt = analyser.filters[i][0].apply(lowBandIntFilt);
                highBandIntFilt = SignalProcUtils.interpolate(subbands[i].waveform, 2.0);
                highBandIntFilt = analyser.filters[i][1].apply(highBandIntFilt);
                x = new double[Math.max(lowBandIntFilt.length, highBandIntFilt.length)];
                Arrays.fill(x, 0.0);
                System.arraycopy(lowBandIntFilt, 0, x, 0, lowBandIntFilt.length);
                int j = 0;
                while (j < highBandIntFilt.length) {
                    int n = j;
                    x[n] = x[n] + highBandIntFilt[j];
                    ++j;
                }
                if (bNormalizeInOverlappingRegions) {
                    x = SignalProcUtils.filterfd(analyser.normalizationFilterTransformedIRs[i], x, 2.0 * analyser.samplingRates[i]);
                }
                --i;
            }
        }
        return x;
    }

    public static void main(String[] args) throws UnsupportedAudioFileException, IOException {
        String outFileName;
        DDSAudioInputStream outputAudio;
        AudioFormat outputFormat;
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[0]));
        int samplingRate = (int)inputAudio.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
        double[] x = signal.getAllData();
        int numLevels = 3;
        boolean bNormalizeInOverlappingRegions = false;
        FIRWaveletFilterBankAnalyser analyser = new FIRWaveletFilterBankAnalyser(numLevels, samplingRate);
        Subband[] subbands = analyser.apply(x);
        int i = 0;
        while (i < subbands.length) {
            outputFormat = new AudioFormat((int)subbands[i].samplingRate, inputAudio.getFormat().getSampleSizeInBits(), inputAudio.getFormat().getChannels(), true, true);
            outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(subbands[i].waveform), outputFormat);
            outFileName = String.valueOf(args[0].substring(0, args[0].length() - 4)) + "_band" + String.valueOf(i + 1) + ".wav";
            AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outFileName));
            ++i;
        }
        FIRWaveletFilterBankSynthesiser synthesiser = new FIRWaveletFilterBankSynthesiser();
        double[] y = synthesiser.apply(analyser, subbands, bNormalizeInOverlappingRegions);
        outputFormat = new AudioFormat(samplingRate, inputAudio.getFormat().getSampleSizeInBits(), inputAudio.getFormat().getChannels(), true, true);
        outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(y), outputFormat);
        outFileName = String.valueOf(args[0].substring(0, args[0].length() - 4)) + "_resynthesis" + ".wav";
        AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outFileName));
    }
}

