/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.io.File;
import java.util.ArrayList;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.process.EnergyNormaliser;
import marytts.util.data.BaseDoubleDataSource;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.SequenceDoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.data.audio.SilenceAudioInputStream;

public class AudioFileJoiner {
    public static void main(String[] args) throws Exception {
        double[] signal;
        String prop;
        ArrayList<BaseDoubleDataSource> startAudio = new ArrayList<BaseDoubleDataSource>();
        double[] start = null;
        ArrayList<BaseDoubleDataSource> endAudio = new ArrayList<BaseDoubleDataSource>();
        double[] end = null;
        ArrayList<BufferedDoubleDataSource> referenceAudio = new ArrayList<BufferedDoubleDataSource>();
        int i = 0;
        AudioFormat format = AudioSystem.getAudioInputStream(new File(args[0])).getFormat();
        while (!(prop = System.getProperty("audio." + ++i, "args")).equals("args")) {
            if (prop.startsWith("silence:")) {
                double duration = Double.valueOf(prop.substring(prop.indexOf(58) + 1));
                startAudio.add(new AudioDoubleDataSource(new SilenceAudioInputStream(duration, format)));
                continue;
            }
            AudioInputStream ais = AudioSystem.getAudioInputStream(new File(prop));
            if (!format.equals(ais.getFormat())) {
                ais = AudioSystem.getAudioInputStream(format, ais);
            }
            signal = new AudioDoubleDataSource(ais).getAllData();
            startAudio.add(new BufferedDoubleDataSource(signal));
            referenceAudio.add(new BufferedDoubleDataSource(signal));
        }
        if (startAudio.size() > 0) {
            start = new SequenceDoubleDataSource(startAudio).getAllData();
        }
        while ((prop = System.getProperty("audio." + ++i)) != null) {
            if (prop.startsWith("silence:")) {
                double duration = Double.valueOf(prop.substring(prop.indexOf(58) + 1));
                endAudio.add(new AudioDoubleDataSource(new SilenceAudioInputStream(duration, format)));
                continue;
            }
            AudioInputStream ais = AudioSystem.getAudioInputStream(new File(prop));
            if (!format.equals(ais.getFormat())) {
                ais = AudioSystem.getAudioInputStream(format, ais);
            }
            signal = new AudioDoubleDataSource(ais).getAllData();
            endAudio.add(new BufferedDoubleDataSource(signal));
            referenceAudio.add(new BufferedDoubleDataSource(signal));
        }
        if (endAudio.size() > 0) {
            end = new SequenceDoubleDataSource(endAudio).getAllData();
        }
        EnergyNormaliser powerNormaliser = null;
        if (referenceAudio.size() > 0) {
            powerNormaliser = new EnergyNormaliser(new SequenceDoubleDataSource(referenceAudio));
            System.err.println("Reference power: " + powerNormaliser.getReferencePower());
        }
        int k = 0;
        while (k < args.length) {
            File inFile;
            AudioInputStream ais;
            ArrayList<BaseDoubleDataSource> result = new ArrayList<BaseDoubleDataSource>();
            if (start != null) {
                result.add(new BufferedDoubleDataSource(start));
            }
            if (!format.equals((ais = AudioSystem.getAudioInputStream(inFile = new File(args[k]))).getFormat())) {
                ais = AudioSystem.getAudioInputStream(format, ais);
            }
            DoubleDataSource dds = new AudioDoubleDataSource(ais);
            if (powerNormaliser != null) {
                dds = powerNormaliser.apply(dds);
            }
            result.add((BaseDoubleDataSource)dds);
            if (end != null) {
                result.add(new BufferedDoubleDataSource(end));
            }
            SequenceDoubleDataSource resultDDS = new SequenceDoubleDataSource(result);
            DDSAudioInputStream resultStream = new DDSAudioInputStream(resultDDS, format);
            String prefix = System.getProperty("prefix", "joined_");
            String filename = inFile.getName();
            filename = String.valueOf(prefix) + filename.substring(0, filename.lastIndexOf(46)) + ".wav";
            File outFile = new File(filename);
            AudioSystem.write((AudioInputStream)resultStream, AudioFileFormat.Type.WAVE, outFile);
            System.out.println("Wrote " + outFile.getPath());
            ++k;
        }
    }
}

