/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.io.File;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.process.FrameOverlapAddSource;
import marytts.signalproc.process.PolarFrequencyProcessor;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;

public class SimpleNoiseKeeper
extends PolarFrequencyProcessor {
    protected double threshold;

    public SimpleNoiseKeeper(int fftSize, double threshold) {
        super(fftSize);
        this.threshold = threshold;
    }

    @Override
    protected void processPolar(double[] r, double[] phi) {
        int halfWinLength = r.length / 2;
        int i = 0;
        while (i < r.length) {
            double rNorm = r[i] / (double)halfWinLength;
            double factor = rNorm / (rNorm + this.threshold);
            int n = i++;
            r[n] = r[n] * (1.0 - factor);
        }
    }

    public static void main(String[] args) throws Exception {
        int i = 0;
        while (i < args.length) {
            AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[i]));
            int samplingRate = (int)inputAudio.getFormat().getSampleRate();
            AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
            int frameLength = Integer.getInteger("signalproc.simplenoisekeeper.framelength", 1024);
            double threshold = Double.parseDouble(System.getProperty("signalproc.simplenoisekeeper.threshold", "50.0"));
            FrameOverlapAddSource foas = new FrameOverlapAddSource(signal, 3, true, frameLength, samplingRate, new SimpleNoiseKeeper(frameLength, threshold));
            DDSAudioInputStream outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(foas), inputAudio.getFormat());
            String outFileName = String.valueOf(args[i].substring(0, args[i].length() - 4)) + "_noiseonly.wav";
            AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outFileName));
            ++i;
        }
    }
}

