/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.test;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.analysis.PitchReaderWriter;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.math.MathUtils;
import marytts.util.string.StringUtils;

public class BaseTester {
    public static double DEFAULT_ABS_MAX_VAL = 26000.0;
    public static float DEFAULT_AMP = 0.8f;
    public static float DEFAULT_DUR = 1.0f;
    public static int DEFAULT_FS = 16000;
    public static float DEFAULT_WINDOW_SIZE_FOR_PITCH_CONTOUR = 0.02f;
    public static float DEFAULT_SKIP_SIZE_FOR_PITCH_CONTOUR = 0.01f;
    public double[] signal;
    public int[] pitchMarks;
    public double[] f0s;
    public int fs;
    public float ws = DEFAULT_WINDOW_SIZE_FOR_PITCH_CONTOUR;
    public float ss = DEFAULT_SKIP_SIZE_FOR_PITCH_CONTOUR;

    public void write(String outWavFile) throws IOException {
        this.write(outWavFile, DEFAULT_ABS_MAX_VAL);
    }

    public void write(String outWavFile, double defaultAbsMaxVal) throws IOException {
        String outPtcFile = StringUtils.modifyExtension((String)outWavFile, (String)".ptc");
        this.write(outWavFile, outPtcFile, defaultAbsMaxVal);
    }

    public void write(String outWavFile, String outPtcFile) throws IOException {
        this.write(outWavFile, outPtcFile, DEFAULT_ABS_MAX_VAL);
    }

    public void write(String outWavFile, String outPtcFile, double defaultAbsMaxVal) throws IOException {
        if (this.signal != null) {
            if (this.signal != null && outWavFile != null && !outWavFile.equals("")) {
                double maxVal = MathUtils.getAbsMax(this.signal);
                int i = 0;
                while (i < this.signal.length) {
                    int n = i++;
                    this.signal[n] = this.signal[n] * (defaultAbsMaxVal / 32767.0 / maxVal);
                }
                AudioFormat format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.fs, 16, 1, 2, this.fs, true);
                DDSAudioInputStream outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(this.signal), format);
                AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outWavFile));
            }
            if (this.pitchMarks != null && outPtcFile != null && !outWavFile.equals("")) {
                PitchReaderWriter.write_pitch_file(outPtcFile, this.f0s, this.ws, this.ss, this.fs);
            }
        }
    }
}

