/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data.audio;

import java.io.IOException;
import java.io.InputStream;
import marytts.util.MaryUtils;
import marytts.util.data.audio.AudioDestination;
import org.apache.log4j.Logger;

public class AudioReader
extends Thread {
    private InputStream from;
    private AudioDestination audioDestination;
    private byte[] endMarker;
    private long latestSeenTime;
    private Logger logger;

    public AudioReader(InputStream from, AudioDestination audioDestination) {
        this(from, audioDestination, null);
    }

    public AudioReader(InputStream from, AudioDestination audioDestination, String endMarker) {
        super(String.valueOf(Thread.currentThread().getName()) + " reader");
        this.from = from;
        this.audioDestination = audioDestination;
        this.endMarker = endMarker != null ? endMarker.getBytes() : null;
        this.latestSeenTime = System.currentTimeMillis();
        this.logger = MaryUtils.getLogger((String)"Audio reader");
    }

    @Override
    public void run() {
        byte[] bytes = new byte[8192];
        boolean terminate = false;
        try {
            int nrRead;
            while (!terminate && (nrRead = this.from.read(bytes)) > -1) {
                int start;
                this.latestSeenTime = System.currentTimeMillis();
                this.logger.debug((Object)("Read " + nrRead + " bytes from audio source."));
                if (this.endMarker != null && (start = MaryUtils.indexOf((byte[])bytes, (byte[])this.endMarker)) != -1) {
                    nrRead = start;
                    terminate = true;
                    this.logger.debug((Object)("Found end marker at index position " + start));
                }
                this.audioDestination.write(bytes, 0, nrRead);
            }
            this.logger.info((Object)"Finished reading.");
            this.from.close();
        }
        catch (IOException e) {
            this.logger.warn((Object)"Problem reading from module:", (Throwable)e);
        }
    }

    public long latestSeenTime() {
        return this.latestSeenTime;
    }
}

