/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data.audio;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.AudioRecorder;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.data.audio.SequenceAudioInputStream;

public class MaryAudioUtils {
    static Clip m_clip;

    public static AudioInputStream createSingleAudioInputStream(Vector<AudioInputStream> audioInputStreams) {
        AudioInputStream singleStream;
        if (audioInputStreams == null) {
            throw new NullPointerException("Received null vector of AudioInputStreams");
        }
        if (audioInputStreams.isEmpty()) {
            throw new IllegalArgumentException("Received empty vector of AudioInputStreams");
        }
        if (audioInputStreams.size() == 1) {
            singleStream = audioInputStreams.get(0);
        } else {
            AudioFormat audioFormat = audioInputStreams.get(0).getFormat();
            singleStream = new SequenceAudioInputStream(audioFormat, audioInputStreams);
        }
        return singleStream;
    }

    public static AudioFileFormat.Type getAudioFileFormatType(String name) {
        AudioFileFormat.Type at;
        if (name.equals("MP3")) {
            at = new AudioFileFormat.Type("MP3", "mp3");
        } else if (name.equals("Vorbis")) {
            at = new AudioFileFormat.Type("Vorbis", "ogg");
        } else {
            try {
                at = (AudioFileFormat.Type)AudioFileFormat.Type.class.getField(name).get(null);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return at;
    }

    public static void timedRecord(String filename, long millis, AudioFormat audioFormat) {
        File outputFile = new File(filename);
        MaryAudioUtils.timedRecord(outputFile, millis, audioFormat);
    }

    public static void timedRecord(File targetFile, long millis, AudioFormat audioFormat) {
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, audioFormat);
        TargetDataLine targetDataLine = null;
        try {
            targetDataLine = (TargetDataLine)AudioSystem.getLine(info);
            targetDataLine.open(audioFormat);
        }
        catch (LineUnavailableException e) {
            System.err.println("unable to get a recording line");
            e.printStackTrace();
        }
        AudioFileFormat.Type targetType = AudioFileFormat.Type.WAVE;
        AudioRecorder.BufferingRecorder recorder = new AudioRecorder.BufferingRecorder(targetDataLine, targetType, targetFile, (int)millis);
        recorder.start();
        System.out.println("Recording...");
        try {
            recorder.join();
        }
        catch (InterruptedException interruptedException) {}
        System.out.println("Recording stopped.");
    }

    public static void playWavFile(String filename, int loop) {
        MaryAudioUtils.playWavFile(filename, loop, false);
    }

    public static void playWavFile(String filename, int loop, boolean waitUntilCompleted) {
        AudioInputStream audioInputStream = null;
        File clipFile = new File(filename);
        try {
            audioInputStream = AudioSystem.getAudioInputStream(clipFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (audioInputStream != null) {
            AudioFormat format = audioInputStream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, format);
            try {
                m_clip = (Clip)AudioSystem.getLine(info);
                m_clip.open(audioInputStream);
            }
            catch (LineUnavailableException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            m_clip.loop(loop);
            if (waitUntilCompleted) {
                m_clip.drain();
            }
        } else {
            System.out.println("playWavFile<init>(): can't get data from file " + clipFile.getName());
        }
    }

    public static void stopWavFile() {
        m_clip.stop();
        m_clip.flush();
        m_clip.close();
    }

    public static double[] getSamplesAsDoubleArray(AudioInputStream ais) {
        return new AudioDoubleDataSource(ais).getAllData();
    }

    public static void writeWavFile(double[] x, String outputFile, AudioFormat format) throws IOException {
        DDSAudioInputStream outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(x), format);
        AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outputFile));
    }
}

