/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.math;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import Jama.SingularValueDecomposition;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Vector;
import marytts.util.math.MathUtils;
import marytts.util.math.Regression;

public class PCA {
    private Matrix covariance;
    private double[] V;
    private Matrix PC;
    private double[] varianceProportion;

    public double[][] getCovariance() {
        return this.covariance.getArray();
    }

    public double[] getV() {
        return this.V;
    }

    public double[][] getPC() {
        return this.PC.getArray();
    }

    public double[][] getDataProjected(Matrix data, boolean debug) {
        Matrix dataProjected = this.PC.transpose().times(data);
        if (debug) {
            System.out.println("Data projected:");
            dataProjected.print(dataProjected.getRowDimension(), 3);
        }
        return dataProjected.getArray();
    }

    public void printPricipalComponents() {
        System.out.println("PC");
        this.PC.print(this.PC.getRowDimension(), 4);
    }

    public void printPricipalComponents(Vector<String> factors) {
        System.out.println("PCs:");
        int j = 0;
        while (j < this.PC.getColumnDimension()) {
            System.out.println("PC(" + j + ")");
            int i = 0;
            while (i < this.PC.getRowDimension()) {
                System.out.format(" %s %.5f\n", factors.elementAt(i), this.PC.get(i, j));
                ++i;
            }
            ++j;
        }
    }

    public void printPricipalComponents(String[] factors, int numPCA) {
        if (numPCA >= 1 && numPCA <= this.PC.getColumnDimension()) {
            int index;
            System.out.println("Ordered PC(" + numPCA + ")");
            --numPCA;
            double[] loadings = new double[this.PC.getRowDimension()];
            int i = 0;
            while (i < this.PC.getRowDimension()) {
                loadings[i] = Math.abs(this.PC.get(i, numPCA));
                ++i;
            }
            int[] indices = MathUtils.quickSort(loadings);
            int i2 = this.PC.getRowDimension() - 1;
            while (i2 >= 0) {
                index = indices[i2];
                System.out.format(" %s %.5f\n", factors[index], this.PC.get(index, numPCA));
                --i2;
            }
            i2 = this.PC.getRowDimension() - 1;
            while (i2 >= 0) {
                index = indices[i2];
                System.out.format("%s\n", factors[index]);
                --i2;
            }
        } else {
            System.out.println("PC number should be >= 1 and <= " + this.PC.getColumnDimension());
        }
    }

    public void printImportanceOfComponents() {
        System.out.println("Importance of components:");
        int j = 0;
        while (j < this.varianceProportion.length) {
            System.out.format("PC(%s)=%.4f ", j + 1, this.varianceProportion[j]);
            ++j;
        }
        System.out.println();
    }

    public double[] getImportanceOfComponents() {
        return this.varianceProportion;
    }

    public double getImportanceOfComponents(int numPC) {
        return this.varianceProportion[numPC];
    }

    public void principalComponentAnalysis(Vector<Double> data, int rows, int cols, boolean eigen, boolean scale) {
        if (data == null) {
            throw new NullPointerException("Null data");
        }
        if (rows < 0 || cols < 0) {
            throw new IllegalArgumentException("Number of rows and cols must be greater than 0");
        }
        Matrix dataX = new Matrix(rows, cols);
        int n = 0;
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                dataX.set(i, j, data.elementAt(n++).doubleValue());
                ++j;
            }
            ++i;
        }
        boolean debug = false;
        if (eigen) {
            this.eigenPCA(dataX, scale, debug);
        } else {
            this.svdPCA(dataX, scale, debug);
        }
    }

    public void eigenPCA(Matrix data, boolean scale, boolean debug) {
        int M = data.getRowDimension();
        int N = data.getColumnDimension();
        int i = 0;
        while (i < M) {
            int j;
            double mn = MathUtils.mean(data.getArray()[i]);
            if (mn == 0.0) {
                throw new Error("eigenPCA: mean of dimension " + (i + 1) + " is 0.0");
            }
            if (scale) {
                double sd = MathUtils.standardDeviation(data.getArray()[i]);
                if (sd == 0.0) {
                    throw new Error("eigenPCA: variance of dimension " + (i + 1) + " is 0.0");
                }
                j = 0;
                while (j < N) {
                    data.set(i, j, (data.get(i, j) - mn) / sd);
                    ++j;
                }
            } else {
                j = 0;
                while (j < N) {
                    data.set(i, j, data.get(i, j) - mn);
                    ++j;
                }
            }
            ++i;
        }
        if (debug) {
            System.out.println("Data:");
            data.print(data.getRowDimension(), 3);
        }
        this.covariance = data.times(data.transpose());
        this.covariance = this.covariance.times(1.0 / (double)(N - 1));
        if (debug) {
            System.out.println("Covariance");
            this.covariance.print(this.covariance.getRowDimension(), 3);
        }
        EigenvalueDecomposition pc = this.covariance.eig();
        if (debug) {
            System.out.println("EigenValues (on the diagonal)");
            pc.getD().print(pc.getD().getRowDimension(), 3);
            System.out.println("EigenVectors");
            pc.getV().print(pc.getV().getRowDimension(), 3);
        }
        double[] values = new double[pc.getD().getRowDimension()];
        int i2 = 0;
        while (i2 < pc.getD().getRowDimension()) {
            values[i2] = pc.getD().get(i2, i2);
            ++i2;
        }
        int[] indices = MathUtils.quickSort(values);
        this.V = new double[values.length];
        double[][] d = new double[pc.getV().getRowDimension()][pc.getV().getColumnDimension()];
        int j = 0;
        while (j < values.length) {
            int k = indices[values.length - 1 - j];
            this.V[j] = values[k];
            int i3 = 0;
            while (i3 < pc.getV().getRowDimension()) {
                d[i3][j] = pc.getV().get(i3, k);
                ++i3;
            }
            ++j;
        }
        this.PC = new Matrix(d);
        if (debug) {
            System.out.println("PC:");
            this.PC.print(this.PC.getRowDimension(), 3);
        }
        Matrix projectedData = this.PC.transpose().times(data);
        Matrix covProjectedData = projectedData.times(projectedData.transpose());
        this.varianceProportion = new double[covProjectedData.getColumnDimension()];
        double sumPropVar = 0.0;
        int j2 = 0;
        while (j2 < covProjectedData.getColumnDimension()) {
            this.varianceProportion[j2] = covProjectedData.get(j2, j2);
            sumPropVar += this.varianceProportion[j2];
            ++j2;
        }
        j2 = 0;
        while (j2 < covProjectedData.getColumnDimension()) {
            this.varianceProportion[j2] = this.varianceProportion[j2] / sumPropVar;
            ++j2;
        }
    }

    public void svdPCA(Matrix data, boolean scale, boolean debug) {
        int M = data.getRowDimension();
        int N = data.getColumnDimension();
        int i = 0;
        while (i < M) {
            int j;
            double mn = MathUtils.mean(data.getArray()[i]);
            if (mn == 0.0) {
                throw new Error("svdPCA: mean of dimension " + (i + 1) + " is 0.0");
            }
            if (scale) {
                double sd = MathUtils.standardDeviation(data.getArray()[i]);
                if (sd == 0.0) {
                    throw new Error("svdPCA: variance of dimension " + (i + 1) + " is 0.0");
                }
                j = 0;
                while (j < N) {
                    data.set(i, j, (data.get(i, j) - mn) / sd);
                    ++j;
                }
            } else {
                j = 0;
                while (j < N) {
                    data.set(i, j, data.get(i, j) - mn);
                    ++j;
                }
            }
            ++i;
        }
        if (debug) {
            System.out.println("Data:");
            data.print(data.getRowDimension(), 3);
        }
        Matrix Y = data.transpose();
        Y = Y.times(1.0 / Math.sqrt(N - 1));
        SingularValueDecomposition svd = Y.svd();
        if (debug) {
            System.out.println("Values:");
        }
        this.V = new double[svd.getS().getRowDimension()];
        int i2 = 0;
        while (i2 < svd.getS().getRowDimension()) {
            this.V[i2] = svd.getS().get(i2, i2);
            if (debug) {
                System.out.println(this.V[i2]);
            }
            ++i2;
        }
        this.PC = svd.getV();
        if (debug) {
            System.out.println("PC:");
            this.PC.print(this.PC.getRowDimension(), 3);
        }
        Matrix projectedData = this.PC.transpose().times(data);
        Matrix covProjectedData = projectedData.times(projectedData.transpose());
        this.varianceProportion = new double[covProjectedData.getColumnDimension()];
        double sumPropVar = 0.0;
        int j = 0;
        while (j < covProjectedData.getColumnDimension()) {
            this.varianceProportion[j] = covProjectedData.get(j, j);
            sumPropVar += this.varianceProportion[j];
            ++j;
        }
        j = 0;
        while (j < covProjectedData.getColumnDimension()) {
            this.varianceProportion[j] = this.varianceProportion[j] / sumPropVar;
            ++j;
        }
    }

    public void principalComponentAnalysis(String fileName, boolean eigen, boolean scale) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            Matrix data = Matrix.read((BufferedReader)reader);
            int rows = data.getRowDimension() - 1;
            int cols = data.getColumnDimension() - 1;
            data = data.getMatrix(0, rows, 1, cols);
            if (eigen) {
                this.eigenPCA(data.transpose(), scale, false);
            } else {
                this.svdPCA(data.transpose(), scale, false);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Problem reading file " + fileName, e);
        }
    }

    public static void main(String[] args) throws Exception {
        String dataFile = "/project/mary/marcela/UnitSel-voices/slt-arctic/temp/dur-vowels.data";
        BufferedReader reader = new BufferedReader(new FileReader(dataFile));
        Matrix dataVowels = Matrix.read((BufferedReader)reader);
        int rows = dataVowels.getRowDimension() - 1;
        int cols = dataVowels.getColumnDimension() - 1;
        Matrix indVar = dataVowels.getMatrix(0, rows, 0, 0);
        dataVowels = dataVowels.getMatrix(0, rows, 1, cols);
        PCA pca = new PCA();
        pca.svdPCA(dataVowels.transpose(), true, false);
        pca.printPricipalComponents();
        Regression regVowel = new Regression();
        regVowel.multipleLinearRegression(indVar, dataVowels, true);
        regVowel.printCoefficients();
        System.out.println("Correlation vowels original duration / predicted duration = " + regVowel.getCorrelation());
    }
}

