/*
 * Decompiled with CFR 0.152.
 */
package org.jsresources;

import java.io.IOException;
import java.util.Collection;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.jsresources.SequenceAudioInputStream;

public class AppendableSequenceAudioInputStream
extends SequenceAudioInputStream {
    protected boolean doneAppending = false;

    public AppendableSequenceAudioInputStream(AudioFormat audioFormat, Collection audioInputStreams) {
        super(audioFormat, audioInputStreams);
    }

    public synchronized void append(AudioInputStream ais) {
        if (ais == this) {
            throw new IllegalArgumentException("Cannot append me to myself");
        }
        if (this.doneAppending) {
            throw new IllegalArgumentException("Cannot append after doneAppending() was called!");
        }
        this.m_audioInputStreamList.add(ais);
        this.notifyAll();
    }

    public synchronized void doneAppending() {
        this.doneAppending = true;
        this.notifyAll();
    }

    @Override
    public synchronized int read() throws IOException {
        while (this.m_audioInputStreamList.size() == 0) {
            if (this.doneAppending) {
                return -1;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        int n = -1;
        while ((n = super.read()) <= 0) {
            if (n == -1 && this.doneAppending) {
                return -1;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return n;
    }

    @Override
    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        int n = -1;
        while (this.m_audioInputStreamList.size() == 0) {
            if (this.doneAppending) {
                return -1;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        while (this.m_nCurrentStream >= this.m_audioInputStreamList.size() || (n = super.read(buf, off, len)) <= 0) {
            if (n == -1 && this.doneAppending) {
                return -1;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return n;
    }

    @Override
    public long getFrameLength() {
        if (!this.doneAppending) {
            return -1L;
        }
        long total = 0L;
        int i = 0;
        int n = this.m_audioInputStreamList.size();
        while (i < n) {
            long length = ((AudioInputStream)this.m_audioInputStreamList.get(i)).getFrameLength();
            if (length == -1L) {
                return -1L;
            }
            total += length;
            ++i;
        }
        return total;
    }
}

