/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.watsonx;

import com.ibm.watsonx.ai.chat.ChatRequest;
import com.ibm.watsonx.ai.chat.ChatResponse;
import com.ibm.watsonx.ai.chat.model.ChatParameters;
import com.ibm.watsonx.ai.chat.model.ChatUsage;
import com.ibm.watsonx.ai.chat.model.ResultMessage;
import com.ibm.watsonx.ai.chat.model.Tool;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.exception.ContentFilteredException;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.ModelProvider;
import dev.langchain4j.model.chat.Capability;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.model.watsonx.Converter;
import dev.langchain4j.model.watsonx.WatsonxChat;
import dev.langchain4j.model.watsonx.WatsonxChatResponseMetadata;
import dev.langchain4j.model.watsonx.WatsonxExceptionMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class WatsonxChatModel
extends WatsonxChat
implements ChatModel {
    private WatsonxChatModel(Builder builder) {
        super(builder);
    }

    public ChatResponse doChat(dev.langchain4j.model.chat.request.ChatRequest chatRequest) {
        this.validate(chatRequest.parameters());
        List toolSpecifications = Utils.getOrDefault((List)chatRequest.parameters().toolSpecifications(), (List)this.defaultRequestParameters.toolSpecifications());
        List messages = chatRequest.messages().stream().map(Converter::toChatMessage).collect(Collectors.toCollection(ArrayList::new));
        List<Tool> tools = Objects.nonNull(toolSpecifications) && toolSpecifications.size() > 0 ? toolSpecifications.stream().map(Converter::toTool).toList() : null;
        ChatRequest.Builder watsonxChatRequest = ChatRequest.builder();
        if (this.isThinkingActivable(chatRequest.messages(), toolSpecifications)) {
            messages.add(THINKING);
            watsonxChatRequest.thinking(this.tags);
        }
        ChatParameters parameters = Converter.toChatParameters(chatRequest.parameters());
        com.ibm.watsonx.ai.chat.ChatResponse chatResponse = (com.ibm.watsonx.ai.chat.ChatResponse)WatsonxExceptionMapper.INSTANCE.withExceptionMapper(() -> this.chatService.chat(watsonxChatRequest.messages(messages).tools(tools).parameters(parameters).build()));
        ChatResponse.ResultChoice choice = (ChatResponse.ResultChoice)chatResponse.getChoices().get(0);
        ChatUsage usage = chatResponse.getUsage();
        ResultMessage message = choice.getMessage();
        if (Utils.isNotNullOrBlank((String)message.refusal())) {
            throw new ContentFilteredException(message.refusal());
        }
        AiMessage.Builder aiMessage = AiMessage.builder();
        if (Objects.nonNull(message.toolCalls()) && !message.toolCalls().isEmpty()) {
            aiMessage.toolExecutionRequests(message.toolCalls().stream().map(Converter::toToolExecutionRequest).toList());
        } else if (Objects.nonNull(this.tags)) {
            aiMessage.thinking(chatResponse.extractThinking());
            aiMessage.text(chatResponse.extractContent());
        } else {
            aiMessage.text(message.content());
        }
        FinishReason finishReason = Converter.toFinishReason(choice.getFinishReason());
        TokenUsage tokenUsage = new TokenUsage(usage.getPromptTokens(), usage.getCompletionTokens(), usage.getTotalTokens());
        return ChatResponse.builder().aiMessage(aiMessage.build()).metadata(((WatsonxChatResponseMetadata.Builder)((WatsonxChatResponseMetadata.Builder)((WatsonxChatResponseMetadata.Builder)((WatsonxChatResponseMetadata.Builder)WatsonxChatResponseMetadata.builder().created(chatResponse.getCreated()).modelVersion(chatResponse.getModelVersion()).finishReason(finishReason)).id(chatResponse.getId())).modelName(chatResponse.getModelId())).tokenUsage(tokenUsage)).build()).build();
    }

    public List<ChatModelListener> listeners() {
        return this.listeners;
    }

    public ChatRequestParameters defaultRequestParameters() {
        return this.defaultRequestParameters;
    }

    public ModelProvider provider() {
        return ModelProvider.WATSONX;
    }

    public Set<Capability> supportedCapabilities() {
        return this.supportedCapabilities;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends WatsonxChat.Builder<Builder> {
        private Builder() {
        }

        public WatsonxChatModel build() {
            return new WatsonxChatModel(this);
        }
    }
}

