/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.shaded.jvnet.hk2.internal;

import fish.payara.arquillian.shaded.aopalliance.intercept.MethodInterceptor;
import fish.payara.arquillian.shaded.glassfish.hk2.api.AOPProxyCtl;
import fish.payara.arquillian.shaded.glassfish.hk2.utilities.reflection.Logger;
import fish.payara.arquillian.shaded.javassist.util.proxy.MethodFilter;
import fish.payara.arquillian.shaded.javassist.util.proxy.ProxyFactory;
import fish.payara.arquillian.shaded.jvnet.hk2.internal.ClazzCreator;
import fish.payara.arquillian.shaded.jvnet.hk2.internal.ConstructorAction;
import fish.payara.arquillian.shaded.jvnet.hk2.internal.MethodInterceptorHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;

final class ConstructorActionImpl<T>
implements ConstructorAction {
    private static final Class<?>[] ADDED_INTERFACES = new Class[]{AOPProxyCtl.class};
    private static final MethodFilter METHOD_FILTER = new MethodFilter(){

        @Override
        public boolean isHandled(Method method) {
            return !method.getName().equals("finalize");
        }
    };
    private final ClazzCreator<T> clazzCreator;
    private final Map<Method, List<MethodInterceptor>> methodInterceptors;

    ConstructorActionImpl(ClazzCreator<T> clazzCreator, Map<Method, List<MethodInterceptor>> methodInterceptors) {
        this.clazzCreator = clazzCreator;
        this.methodInterceptors = methodInterceptors;
    }

    @Override
    public Object makeMe(final Constructor<?> c, final Object[] args, final boolean neutralCCL) throws Throwable {
        final MethodInterceptorHandler methodInterceptor = new MethodInterceptorHandler(this.clazzCreator.getServiceLocator(), this.clazzCreator.getUnderlyingDescriptor(), this.methodInterceptors);
        final ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setSuperclass(this.clazzCreator.getImplClass());
        proxyFactory.setFilter(METHOD_FILTER);
        proxyFactory.setInterfaces(ADDED_INTERFACES);
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                ClassLoader currentCCL = null;
                if (neutralCCL) {
                    currentCCL = Thread.currentThread().getContextClassLoader();
                }
                try {
                    Object object = proxyFactory.create(c.getParameterTypes(), args, methodInterceptor);
                    return object;
                }
                catch (InvocationTargetException ite) {
                    Throwable targetException = ite.getTargetException();
                    Logger.getLogger().debug(c.getDeclaringClass().getName(), c.getName(), targetException);
                    if (targetException instanceof Exception) {
                        throw (Exception)targetException;
                    }
                    throw new RuntimeException(targetException);
                }
                finally {
                    if (neutralCCL) {
                        Thread.currentThread().setContextClassLoader(currentCCL);
                    }
                }
            }
        });
    }
}

