/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen;

import io.helidon.codegen.ClassCode;
import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenFiler;
import io.helidon.codegen.CodegenOptions;
import io.helidon.codegen.Option;
import io.helidon.codegen.RoundContextImpl;
import io.helidon.codegen.TypeHierarchy;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.spi.CodegenExtension;
import io.helidon.codegen.spi.CodegenExtensionProvider;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Codegen {
    private static final List<CodegenExtensionProvider> EXTENSIONS = HelidonServiceLoader.create(ServiceLoader.load(CodegenExtensionProvider.class, Codegen.class.getClassLoader())).asList();
    private static final Set<Option<?>> SUPPORTED_APT_OPTIONS;
    private final CodegenContext ctx;
    private final List<ExtensionInfo> extensions;
    private final Set<TypeName> supportedAnnotations;
    private final Set<TypeName> supportedMetaAnnotations;
    private final Set<String> supportedPackagePrefixes;

    private Codegen(CodegenContext ctx, TypeName generator) {
        this.ctx = ctx;
        HashSet<TypeName> supportedAnnotations = new HashSet<TypeName>(ctx.mapperSupportedAnnotations());
        HashSet supportedMetaAnnotations = new HashSet();
        HashSet supportedPackagePrefixes = new HashSet();
        this.extensions = EXTENSIONS.stream().map(it -> {
            CodegenExtension extension = it.create(this.ctx, generator);
            Set<TypeName> extensionAnnotations = it.supportedAnnotations();
            Set<String> extensionPackages = it.supportedAnnotationPackages();
            Set<TypeName> extensionMetaAnnotations = it.supportedMetaAnnotations();
            supportedAnnotations.addAll(extensionAnnotations);
            supportedMetaAnnotations.addAll(extensionMetaAnnotations);
            supportedPackagePrefixes.addAll(extensionPackages);
            Predicate<TypeName> annotationPredicate = Codegen.discoveryPredicate(extensionAnnotations, extensionPackages);
            return new ExtensionInfo(extension, annotationPredicate, extensionMetaAnnotations);
        }).toList();
        ctx.mapperSupportedAnnotationPackages().stream().map(Codegen::toPackagePrefix).forEach(supportedPackagePrefixes::add);
        this.supportedAnnotations = Set.copyOf(supportedAnnotations);
        this.supportedPackagePrefixes = Set.copyOf(supportedPackagePrefixes);
        this.supportedMetaAnnotations = Set.copyOf(supportedMetaAnnotations);
    }

    public static Codegen create(CodegenContext ctx, TypeName generator) {
        Codegen codegen = new Codegen(ctx, generator);
        HashSet allOptions = new HashSet(SUPPORTED_APT_OPTIONS);
        allOptions.addAll(ctx.supportedOptions());
        ctx.options().validate(allOptions);
        return codegen;
    }

    public static Set<Option<?>> supportedOptions() {
        return SUPPORTED_APT_OPTIONS;
    }

    public void process(List<TypeInfo> allTypes) {
        ArrayList<ClassCode> toWrite = new ArrayList<ClassCode>();
        List<TypeInfoAndAnnotations> annotatedTypes = this.annotatedTypes(allTypes);
        for (ExtensionInfo extension : this.extensions) {
            RoundContextImpl roundCtx = this.createRoundContext(annotatedTypes, extension, toWrite);
            extension.extension().process(roundCtx);
            toWrite.addAll(roundCtx.newTypes());
        }
        this.writeNewTypes(toWrite);
    }

    public void processingOver() {
        ArrayList<ClassCode> toWrite = new ArrayList<ClassCode>();
        for (ExtensionInfo extension : this.extensions) {
            RoundContextImpl roundCtx = this.createRoundContext(List.of(), extension, toWrite);
            extension.extension().processingOver(roundCtx);
            toWrite.addAll(roundCtx.newTypes());
        }
        this.writeNewTypes(toWrite);
    }

    public Set<TypeName> supportedAnnotations() {
        return this.supportedAnnotations;
    }

    public Set<String> supportedAnnotationPackagePrefixes() {
        return this.supportedPackagePrefixes;
    }

    public Set<TypeName> supportedMetaAnnotations() {
        return this.supportedMetaAnnotations;
    }

    private static Predicate<TypeName> discoveryPredicate(Set<TypeName> extensionAnnotations, Collection<String> extensionPackages) {
        List<String> prefixes = extensionPackages.stream().map(it -> it.endsWith(".*") ? it.substring(0, it.length() - 2) : it).toList();
        return typeName -> {
            if (extensionAnnotations.contains(typeName)) {
                return true;
            }
            String packageName = typeName.packageName();
            for (String prefix : prefixes) {
                if (!packageName.startsWith(prefix)) continue;
                return true;
            }
            return false;
        };
    }

    private static String toPackagePrefix(String configured) {
        if (configured.endsWith(".*")) {
            return configured.substring(0, configured.length() - 1);
        }
        if (configured.endsWith(".")) {
            return configured;
        }
        return configured + ".";
    }

    private List<TypeInfoAndAnnotations> annotatedTypes(List<TypeInfo> allTypes) {
        ArrayList<TypeInfoAndAnnotations> result = new ArrayList<TypeInfoAndAnnotations>();
        for (TypeInfo typeInfo : allTypes) {
            result.add(new TypeInfoAndAnnotations(typeInfo, TypeHierarchy.nestedAnnotations(this.ctx, typeInfo)));
        }
        return result;
    }

    private void writeNewTypes(List<ClassCode> toWrite) {
        CodegenFiler filer = this.ctx.filer();
        for (ClassCode classCode : toWrite) {
            ClassModel classModel = classCode.classModel().build();
            filer.writeSourceFile(classModel, classCode.originatingElements());
        }
    }

    private RoundContextImpl createRoundContext(List<TypeInfoAndAnnotations> annotatedTypes, ExtensionInfo extension, List<ClassCode> newTypes) {
        HashSet<TypeName> availableAnnotations = new HashSet<TypeName>();
        HashMap<TypeName, List> annotationToTypes = new HashMap<TypeName, List>();
        HashMap<TypeName, TypeInfo> processedTypes = new HashMap<TypeName, TypeInfo>();
        HashMap<TypeName, Set<TypeName>> metaAnnotationToAnnotations = new HashMap<TypeName, Set<TypeName>>();
        for (TypeInfoAndAnnotations annotatedType : annotatedTypes) {
            for (TypeName annotationType : annotatedType.annotations()) {
                boolean metaAnnotated = this.metaAnnotations(extension, metaAnnotationToAnnotations, annotationType);
                if (!metaAnnotated && !extension.supportedAnnotationsPredicate().test(annotationType)) continue;
                availableAnnotations.add(annotationType);
                processedTypes.put(annotatedType.typeInfo().typeName(), annotatedType.typeInfo());
                annotationToTypes.computeIfAbsent(annotationType, k -> new ArrayList()).add(annotatedType.typeInfo());
            }
        }
        return new RoundContextImpl(this.ctx, newTypes, Set.copyOf(availableAnnotations), Map.copyOf(annotationToTypes), Map.copyOf(metaAnnotationToAnnotations), List.copyOf(processedTypes.values()));
    }

    private boolean metaAnnotations(ExtensionInfo extension, Map<TypeName, Set<TypeName>> metaAnnotationToAnnotations, TypeName annotationType) {
        Optional<TypeInfo> annotationInfo = this.ctx.typeInfo(annotationType);
        if (annotationInfo.isEmpty()) {
            return false;
        }
        TypeInfo annotationTypeInfo = annotationInfo.get();
        boolean metaAnnotated = false;
        for (TypeName metaAnnotation : extension.supportedMetaAnnotations()) {
            for (Annotation anAnnotation : annotationTypeInfo.allAnnotations()) {
                if (!anAnnotation.typeName().equals((Object)metaAnnotation)) continue;
                metaAnnotated = true;
                metaAnnotationToAnnotations.computeIfAbsent(metaAnnotation, k -> new HashSet()).add(annotationType);
            }
        }
        return metaAnnotated;
    }

    static {
        Set supportedOptions = EXTENSIONS.stream().flatMap(it -> it.supportedOptions().stream()).collect(Collectors.toSet());
        supportedOptions.add(CodegenOptions.CODEGEN_SCOPE);
        supportedOptions.add(CodegenOptions.INDENT_TYPE);
        supportedOptions.add(CodegenOptions.INDENT_COUNT);
        SUPPORTED_APT_OPTIONS = Set.copyOf(supportedOptions);
    }

    private record ExtensionInfo(CodegenExtension extension, Predicate<TypeName> supportedAnnotationsPredicate, Set<TypeName> supportedMetaAnnotations) {
    }

    private record TypeInfoAndAnnotations(TypeInfo typeInfo, Set<TypeName> annotations) {
    }
}

