/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.faulttolerance.CircuitBreaker;
import io.helidon.faulttolerance.CircuitBreakerConfig;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;

@Prototype.Blueprint(decorator=BuilderDecorator.class)
@Prototype.Configured(value="fault-tolerance.circuit-breakers")
interface CircuitBreakerConfigBlueprint
extends Prototype.Factory<CircuitBreaker> {
    public static final int DEFAULT_ERROR_RATIO = 60;
    public static final int DEFAULT_SUCCESS_THRESHOLD = 1;
    public static final int DEFAULT_VOLUME = 10;

    public Optional<String> name();

    @Option.Configured
    @Option.Default(value={"PT5S"})
    public Duration delay();

    @Option.Configured
    @Option.DefaultInt(value={60})
    public int errorRatio();

    @Option.Configured
    @Option.DefaultInt(value={10})
    public int volume();

    @Option.Configured
    @Option.DefaultInt(value={1})
    public int successThreshold();

    public Optional<ExecutorService> executor();

    @Option.Singular
    public Set<Class<? extends Throwable>> skipOn();

    @Option.Singular
    public Set<Class<? extends Throwable>> applyOn();

    @Option.Configured
    @Option.DefaultBoolean(value={false})
    public boolean enableMetrics();

    public static class BuilderDecorator
    implements Prototype.BuilderDecorator<CircuitBreakerConfig.BuilderBase<?, ?>> {
        public void decorate(CircuitBreakerConfig.BuilderBase<?, ?> target) {
            if (target.name().isEmpty()) {
                target.config().ifPresent(cfg -> target.name(cfg.name()));
            }
        }
    }
}

