/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.health.checks;

import io.helidon.common.config.Config;
import io.helidon.health.HealthCheck;
import io.helidon.health.HealthCheckException;
import io.helidon.health.HealthCheckResponse;
import io.helidon.health.HealthCheckType;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Formatter;
import java.util.Locale;

public class DiskSpaceHealthCheck
implements HealthCheck {
    public static final String DEFAULT_PATH = ".";
    public static final double DEFAULT_THRESHOLD = 99.999;
    static final String CONFIG_KEY_DISKSPACE_PREFIX = "diskSpace";
    static final String CONFIG_KEY_PATH_SUFFIX = "path";
    static final String CONFIG_KEY_THRESHOLD_PERCENT_SUFFIX = "thresholdPercent";
    public static final String CONFIG_KEY_PATH = "helidon.health.diskSpace.path";
    public static final String CONFIG_KEY_THRESHOLD_PERCENT = "helidon.health.diskSpace.thresholdPercent";
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final long GB = 0x40000000L;
    private static final long TB = 0x10000000000L;
    private static final long PB = 0x4000000000000L;
    private final double thresholdPercent;
    private final FileStore fileStore;

    DiskSpaceHealthCheck(FileStore fileStore, double thresholdPercent) {
        this.fileStore = fileStore;
        this.thresholdPercent = thresholdPercent;
    }

    private DiskSpaceHealthCheck(Builder builder) {
        try {
            this.fileStore = Files.getFileStore(builder.path);
        }
        catch (IOException e) {
            throw new HealthCheckException("Failed to obtain file store for path " + String.valueOf(builder.path.toAbsolutePath()), (Throwable)e);
        }
        this.thresholdPercent = builder.threshold;
    }

    static String format(long bytes) {
        Formatter formatter = new Formatter(Locale.US);
        if (bytes >= 0x4000000000000L) {
            return formatter.format("%.2f PB", (double)bytes / 1.125899906842624E15).toString();
        }
        if (bytes >= 0x10000000000L) {
            return formatter.format("%.2f TB", (double)bytes / 1.099511627776E12).toString();
        }
        if (bytes >= 0x40000000L) {
            return formatter.format("%.2f GB", (double)bytes / 1.073741824E9).toString();
        }
        if (bytes >= 0x100000L) {
            return formatter.format("%.2f MB", (double)bytes / 1048576.0).toString();
        }
        if (bytes >= 1024L) {
            return formatter.format("%.2f KB", (double)bytes / 1024.0).toString();
        }
        return bytes + " bytes";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DiskSpaceHealthCheck create() {
        return DiskSpaceHealthCheck.builder().build();
    }

    public HealthCheckType type() {
        return HealthCheckType.LIVENESS;
    }

    public String name() {
        return CONFIG_KEY_DISKSPACE_PREFIX;
    }

    public String path() {
        return "diskspace";
    }

    public HealthCheckResponse call() {
        long totalInBytes;
        long diskFreeInBytes;
        try {
            diskFreeInBytes = this.fileStore.getUsableSpace();
            totalInBytes = this.fileStore.getTotalSpace();
        }
        catch (IOException e) {
            throw new HealthCheckException("Failed to obtain disk space data", (Throwable)e);
        }
        long usedInBytes = totalInBytes - diskFreeInBytes;
        long threshold = (long)(this.thresholdPercent / 100.0 * (double)totalInBytes);
        Formatter formatter = new Formatter(Locale.US);
        return HealthCheckResponse.builder().status(threshold >= usedInBytes).detail("percentFree", (Object)formatter.format("%.2f%%", 100.0 * ((double)diskFreeInBytes / (double)totalInBytes)).toString()).detail("free", (Object)DiskSpaceHealthCheck.format(diskFreeInBytes)).detail("freeBytes", (Object)diskFreeInBytes).detail("total", (Object)DiskSpaceHealthCheck.format(totalInBytes)).detail("totalBytes", (Object)totalInBytes).build();
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, DiskSpaceHealthCheck> {
        private Path path = Paths.get(".", new String[0]);
        private double threshold = 99.999;

        private Builder() {
        }

        public DiskSpaceHealthCheck build() {
            return new DiskSpaceHealthCheck(this);
        }

        public Builder path(String path) {
            this.path = Paths.get(path, new String[0]);
            return this;
        }

        public Builder path(Path path) {
            this.path = path;
            return this;
        }

        public Builder thresholdPercent(double threshold) {
            this.threshold = threshold;
            return this;
        }

        public Builder config(Config config) {
            config.get(DiskSpaceHealthCheck.CONFIG_KEY_PATH).as(Path.class).ifPresent(this::path);
            config.get(DiskSpaceHealthCheck.CONFIG_KEY_THRESHOLD_PERCENT).asDouble().ifPresent(this::thresholdPercent);
            return this;
        }
    }
}

