/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.langchain4j.providers.openai;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigBuilderSupport;
import io.helidon.integrations.langchain4j.providers.openai.OpenAiImageModelConfigBlueprint;
import java.net.Proxy;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.integrations.langchain4j.providers.openai.OpenAiImageModelConfigBlueprint")
public interface OpenAiImageModelConfig
extends OpenAiImageModelConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(OpenAiImageModelConfig instance) {
        return (Builder)OpenAiImageModelConfig.builder().from(instance);
    }

    public static OpenAiImageModelConfig create(Config config) {
        return ((Builder)OpenAiImageModelConfig.builder().config(config)).buildPrototype();
    }

    public static OpenAiImageModelConfig create() {
        return OpenAiImageModelConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, OpenAiImageModelConfig>
    implements io.helidon.common.Builder<Builder, OpenAiImageModelConfig> {
        private Builder() {
        }

        public OpenAiImageModelConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.OpenAiImageModelConfigImpl(this);
        }

        public OpenAiImageModelConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends OpenAiImageModelConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final Map<String, String> customHeaders = new LinkedHashMap<String, String>();
        private Boolean logRequests;
        private Boolean logResponses;
        private Boolean withPersisting;
        private boolean enabled;
        private Config config;
        private Duration timeout;
        private Integer maxRetries;
        private Path persistTo;
        private Proxy proxy;
        private String apiKey;
        private String baseUrl;
        private String modelName;
        private String organizationId;
        private String quality;
        private String responseFormat;
        private String size;
        private String style;
        private String user;

        protected BuilderBase() {
        }

        public BUILDER from(OpenAiImageModelConfig prototype) {
            this.maxRetries(prototype.maxRetries());
            this.size(prototype.size());
            this.quality(prototype.quality());
            this.style(prototype.style());
            this.user(prototype.user());
            this.responseFormat(prototype.responseFormat());
            this.withPersisting(prototype.withPersisting());
            this.persistTo(prototype.persistTo());
            this.enabled(prototype.enabled());
            this.baseUrl(prototype.baseUrl());
            this.apiKey(prototype.apiKey());
            this.logRequests(prototype.logRequests());
            this.logResponses(prototype.logResponses());
            this.addCustomHeaders(prototype.customHeaders());
            this.timeout(prototype.timeout());
            this.proxy(prototype.proxy());
            this.organizationId(prototype.organizationId());
            this.modelName(prototype.modelName());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.maxRetries().ifPresent(this::maxRetries);
            builder.size().ifPresent(this::size);
            builder.quality().ifPresent(this::quality);
            builder.style().ifPresent(this::style);
            builder.user().ifPresent(this::user);
            builder.responseFormat().ifPresent(this::responseFormat);
            builder.withPersisting().ifPresent(this::withPersisting);
            builder.persistTo().ifPresent(this::persistTo);
            this.enabled(builder.enabled());
            builder.baseUrl().ifPresent(this::baseUrl);
            builder.apiKey().ifPresent(this::apiKey);
            builder.logRequests().ifPresent(this::logRequests);
            builder.logResponses().ifPresent(this::logResponses);
            this.addCustomHeaders(builder.customHeaders);
            builder.timeout().ifPresent(this::timeout);
            builder.proxy().ifPresent(this::proxy);
            builder.organizationId().ifPresent(this::organizationId);
            builder.modelName().ifPresent(this::modelName);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("max-retries").as(Integer.class).ifPresent(this::maxRetries);
            config.get("size").as(String.class).ifPresent(this::size);
            config.get("quality").as(String.class).ifPresent(this::quality);
            config.get("style").as(String.class).ifPresent(this::style);
            config.get("user").as(String.class).ifPresent(this::user);
            config.get("response-format").as(String.class).ifPresent(this::responseFormat);
            config.get("with-persisting").as(Boolean.class).ifPresent(this::withPersisting);
            config.get("persist-to").as(Path.class).ifPresent(this::persistTo);
            config.get("enabled").as(Boolean.class).ifPresent(this::enabled);
            config.get("base-url").as(String.class).ifPresent(this::baseUrl);
            config.get("api-key").as(String.class).ifPresent(this::apiKey);
            config.get("log-requests").as(Boolean.class).ifPresent(this::logRequests);
            config.get("log-responses").as(Boolean.class).ifPresent(this::logResponses);
            config.get("custom-headers").detach().asMap().ifPresent(this::customHeaders);
            config.get("timeout").as(Duration.class).ifPresent(this::timeout);
            config.get("organization-id").as(String.class).ifPresent(this::organizationId);
            config.get("model-name").as(String.class).ifPresent(this::modelName);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearMaxRetries() {
            this.maxRetries = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxRetries(int maxRetries) {
            Objects.requireNonNull(maxRetries);
            this.maxRetries = maxRetries;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearSize() {
            this.size = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER size(String size) {
            Objects.requireNonNull(size);
            this.size = size;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearQuality() {
            this.quality = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER quality(String quality) {
            Objects.requireNonNull(quality);
            this.quality = quality;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearStyle() {
            this.style = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER style(String style) {
            Objects.requireNonNull(style);
            this.style = style;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearUser() {
            this.user = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER user(String user) {
            Objects.requireNonNull(user);
            this.user = user;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearResponseFormat() {
            this.responseFormat = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER responseFormat(String responseFormat) {
            Objects.requireNonNull(responseFormat);
            this.responseFormat = responseFormat;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearWithPersisting() {
            this.withPersisting = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER withPersisting(boolean withPersisting) {
            Objects.requireNonNull(withPersisting);
            this.withPersisting = withPersisting;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearPersistTo() {
            this.persistTo = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER persistTo(Path persistTo) {
            Objects.requireNonNull(persistTo);
            this.persistTo = persistTo;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enabled(boolean enabled) {
            this.enabled = enabled;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearBaseUrl() {
            this.baseUrl = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER baseUrl(String baseUrl) {
            Objects.requireNonNull(baseUrl);
            this.baseUrl = baseUrl;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearApiKey() {
            this.apiKey = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER apiKey(String apiKey) {
            Objects.requireNonNull(apiKey);
            this.apiKey = apiKey;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearLogRequests() {
            this.logRequests = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER logRequests(boolean logRequests) {
            Objects.requireNonNull(logRequests);
            this.logRequests = logRequests;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearLogResponses() {
            this.logResponses = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER logResponses(boolean logResponses) {
            Objects.requireNonNull(logResponses);
            this.logResponses = logResponses;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER customHeaders(Map<String, String> customHeaders) {
            Objects.requireNonNull(customHeaders);
            this.customHeaders.clear();
            this.customHeaders.putAll(customHeaders);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addCustomHeaders(Map<String, String> customHeaders) {
            Objects.requireNonNull(customHeaders);
            this.customHeaders.putAll(customHeaders);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER putCustomHeader(String key, String customHeader) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(customHeader);
            this.customHeaders.put(key, customHeader);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearTimeout() {
            this.timeout = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER timeout(Duration timeout) {
            Objects.requireNonNull(timeout);
            this.timeout = timeout;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearProxy() {
            this.proxy = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER proxy(Proxy proxy) {
            Objects.requireNonNull(proxy);
            this.proxy = proxy;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearOrganizationId() {
            this.organizationId = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER organizationId(String organizationId) {
            Objects.requireNonNull(organizationId);
            this.organizationId = organizationId;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearModelName() {
            this.modelName = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER modelName(String modelName) {
            Objects.requireNonNull(modelName);
            this.modelName = modelName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<Integer> maxRetries() {
            return Optional.ofNullable(this.maxRetries);
        }

        public Optional<String> size() {
            return Optional.ofNullable(this.size);
        }

        public Optional<String> quality() {
            return Optional.ofNullable(this.quality);
        }

        public Optional<String> style() {
            return Optional.ofNullable(this.style);
        }

        public Optional<String> user() {
            return Optional.ofNullable(this.user);
        }

        public Optional<String> responseFormat() {
            return Optional.ofNullable(this.responseFormat);
        }

        public Optional<Boolean> withPersisting() {
            return Optional.ofNullable(this.withPersisting);
        }

        public Optional<Path> persistTo() {
            return Optional.ofNullable(this.persistTo);
        }

        public boolean enabled() {
            return this.enabled;
        }

        public Optional<String> baseUrl() {
            return Optional.ofNullable(this.baseUrl);
        }

        public Optional<String> apiKey() {
            return Optional.ofNullable(this.apiKey);
        }

        public Optional<Boolean> logRequests() {
            return Optional.ofNullable(this.logRequests);
        }

        public Optional<Boolean> logResponses() {
            return Optional.ofNullable(this.logResponses);
        }

        public Map<String, String> customHeaders() {
            return this.customHeaders;
        }

        public Optional<Duration> timeout() {
            return Optional.ofNullable(this.timeout);
        }

        public Optional<Proxy> proxy() {
            return Optional.ofNullable(this.proxy);
        }

        public Optional<String> organizationId() {
            return Optional.ofNullable(this.organizationId);
        }

        public Optional<String> modelName() {
            return Optional.ofNullable(this.modelName);
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "OpenAiImageModelConfigBuilder{maxRetries=" + this.maxRetries + ",size=" + this.size + ",quality=" + this.quality + ",style=" + this.style + ",user=" + this.user + ",responseFormat=" + this.responseFormat + ",withPersisting=" + this.withPersisting + ",persistTo=" + String.valueOf(this.persistTo) + ",enabled=" + this.enabled + ",baseUrl=" + this.baseUrl + ",apiKey=" + this.apiKey + ",logRequests=" + this.logRequests + ",logResponses=" + this.logResponses + ",customHeaders=" + String.valueOf(this.customHeaders) + ",timeout=" + String.valueOf(this.timeout) + ",proxy=" + String.valueOf(this.proxy) + ",organizationId=" + this.organizationId + ",modelName=" + this.modelName + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        BUILDER maxRetries(Optional<Integer> maxRetries) {
            Objects.requireNonNull(maxRetries);
            this.maxRetries = maxRetries.map(Integer.class::cast).orElse(this.maxRetries);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER size(Optional<String> size) {
            Objects.requireNonNull(size);
            this.size = size.map(String.class::cast).orElse(this.size);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER quality(Optional<String> quality) {
            Objects.requireNonNull(quality);
            this.quality = quality.map(String.class::cast).orElse(this.quality);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER style(Optional<String> style) {
            Objects.requireNonNull(style);
            this.style = style.map(String.class::cast).orElse(this.style);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER user(Optional<String> user) {
            Objects.requireNonNull(user);
            this.user = user.map(String.class::cast).orElse(this.user);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER responseFormat(Optional<String> responseFormat) {
            Objects.requireNonNull(responseFormat);
            this.responseFormat = responseFormat.map(String.class::cast).orElse(this.responseFormat);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER withPersisting(Optional<Boolean> withPersisting) {
            Objects.requireNonNull(withPersisting);
            this.withPersisting = withPersisting.map(Boolean.class::cast).orElse(this.withPersisting);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER persistTo(Optional<? extends Path> persistTo) {
            Objects.requireNonNull(persistTo);
            this.persistTo = persistTo.map(Path.class::cast).orElse(this.persistTo);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER baseUrl(Optional<String> baseUrl) {
            Objects.requireNonNull(baseUrl);
            this.baseUrl = baseUrl.map(String.class::cast).orElse(this.baseUrl);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER apiKey(Optional<String> apiKey) {
            Objects.requireNonNull(apiKey);
            this.apiKey = apiKey.map(String.class::cast).orElse(this.apiKey);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER logRequests(Optional<Boolean> logRequests) {
            Objects.requireNonNull(logRequests);
            this.logRequests = logRequests.map(Boolean.class::cast).orElse(this.logRequests);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER logResponses(Optional<Boolean> logResponses) {
            Objects.requireNonNull(logResponses);
            this.logResponses = logResponses.map(Boolean.class::cast).orElse(this.logResponses);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER timeout(Optional<? extends Duration> timeout) {
            Objects.requireNonNull(timeout);
            this.timeout = timeout.map(Duration.class::cast).orElse(this.timeout);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER proxy(Optional<? extends Proxy> proxy) {
            Objects.requireNonNull(proxy);
            this.proxy = proxy.map(Proxy.class::cast).orElse(this.proxy);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER organizationId(Optional<String> organizationId) {
            Objects.requireNonNull(organizationId);
            this.organizationId = organizationId.map(String.class::cast).orElse(this.organizationId);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER modelName(Optional<String> modelName) {
            Objects.requireNonNull(modelName);
            this.modelName = modelName.map(String.class::cast).orElse(this.modelName);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class OpenAiImageModelConfigImpl
        implements OpenAiImageModelConfig {
            private final boolean enabled;
            private final Map<String, String> customHeaders;
            private final Optional<Boolean> logRequests;
            private final Optional<Boolean> logResponses;
            private final Optional<Boolean> withPersisting;
            private final Optional<Integer> maxRetries;
            private final Optional<String> apiKey;
            private final Optional<String> baseUrl;
            private final Optional<String> modelName;
            private final Optional<String> organizationId;
            private final Optional<String> quality;
            private final Optional<String> responseFormat;
            private final Optional<String> size;
            private final Optional<String> style;
            private final Optional<String> user;
            private final Optional<Proxy> proxy;
            private final Optional<Path> persistTo;
            private final Optional<Duration> timeout;

            protected OpenAiImageModelConfigImpl(BuilderBase<?, ?> builder) {
                this.maxRetries = builder.maxRetries();
                this.size = builder.size();
                this.quality = builder.quality();
                this.style = builder.style();
                this.user = builder.user();
                this.responseFormat = builder.responseFormat();
                this.withPersisting = builder.withPersisting();
                this.persistTo = builder.persistTo();
                this.enabled = builder.enabled();
                this.baseUrl = builder.baseUrl();
                this.apiKey = builder.apiKey();
                this.logRequests = builder.logRequests();
                this.logResponses = builder.logResponses();
                this.customHeaders = Collections.unmodifiableMap(new LinkedHashMap<String, String>(builder.customHeaders()));
                this.timeout = builder.timeout();
                this.proxy = builder.proxy();
                this.organizationId = builder.organizationId();
                this.modelName = builder.modelName();
            }

            @Override
            public Optional<Integer> maxRetries() {
                return this.maxRetries;
            }

            @Override
            public Optional<String> size() {
                return this.size;
            }

            @Override
            public Optional<String> quality() {
                return this.quality;
            }

            @Override
            public Optional<String> style() {
                return this.style;
            }

            @Override
            public Optional<String> user() {
                return this.user;
            }

            @Override
            public Optional<String> responseFormat() {
                return this.responseFormat;
            }

            @Override
            public Optional<Boolean> withPersisting() {
                return this.withPersisting;
            }

            @Override
            public Optional<Path> persistTo() {
                return this.persistTo;
            }

            @Override
            public boolean enabled() {
                return this.enabled;
            }

            @Override
            public Optional<String> baseUrl() {
                return this.baseUrl;
            }

            @Override
            public Optional<String> apiKey() {
                return this.apiKey;
            }

            @Override
            public Optional<Boolean> logRequests() {
                return this.logRequests;
            }

            @Override
            public Optional<Boolean> logResponses() {
                return this.logResponses;
            }

            @Override
            public Map<String, String> customHeaders() {
                return this.customHeaders;
            }

            @Override
            public Optional<Duration> timeout() {
                return this.timeout;
            }

            @Override
            public Optional<Proxy> proxy() {
                return this.proxy;
            }

            @Override
            public Optional<String> organizationId() {
                return this.organizationId;
            }

            @Override
            public Optional<String> modelName() {
                return this.modelName;
            }

            public String toString() {
                return "OpenAiImageModelConfig{maxRetries=" + String.valueOf(this.maxRetries) + ",size=" + String.valueOf(this.size) + ",quality=" + String.valueOf(this.quality) + ",style=" + String.valueOf(this.style) + ",user=" + String.valueOf(this.user) + ",responseFormat=" + String.valueOf(this.responseFormat) + ",withPersisting=" + String.valueOf(this.withPersisting) + ",persistTo=" + String.valueOf(this.persistTo) + ",enabled=" + this.enabled + ",baseUrl=" + String.valueOf(this.baseUrl) + ",apiKey=" + String.valueOf(this.apiKey) + ",logRequests=" + String.valueOf(this.logRequests) + ",logResponses=" + String.valueOf(this.logResponses) + ",customHeaders=" + String.valueOf(this.customHeaders) + ",timeout=" + String.valueOf(this.timeout) + ",proxy=" + String.valueOf(this.proxy) + ",organizationId=" + String.valueOf(this.organizationId) + ",modelName=" + String.valueOf(this.modelName) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof OpenAiImageModelConfig)) {
                    return false;
                }
                OpenAiImageModelConfig other = (OpenAiImageModelConfig)o;
                return Objects.equals(this.maxRetries, other.maxRetries()) && Objects.equals(this.size, other.size()) && Objects.equals(this.quality, other.quality()) && Objects.equals(this.style, other.style()) && Objects.equals(this.user, other.user()) && Objects.equals(this.responseFormat, other.responseFormat()) && Objects.equals(this.withPersisting, other.withPersisting()) && Objects.equals(this.persistTo, other.persistTo()) && this.enabled == other.enabled() && Objects.equals(this.baseUrl, other.baseUrl()) && Objects.equals(this.apiKey, other.apiKey()) && Objects.equals(this.logRequests, other.logRequests()) && Objects.equals(this.logResponses, other.logResponses()) && Objects.equals(this.customHeaders, other.customHeaders()) && Objects.equals(this.timeout, other.timeout()) && Objects.equals(this.proxy, other.proxy()) && Objects.equals(this.organizationId, other.organizationId()) && Objects.equals(this.modelName, other.modelName());
            }

            public int hashCode() {
                return Objects.hash(this.maxRetries, this.size, this.quality, this.style, this.user, this.responseFormat, this.withPersisting, this.persistTo, this.enabled, this.baseUrl, this.apiKey, this.logRequests, this.logResponses, this.customHeaders, this.timeout, this.proxy, this.organizationId, this.modelName);
            }
        }
    }
}

