/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.langchain4j.providers.openai;

import dev.langchain4j.model.openai.OpenAiImageModel;
import io.helidon.common.Weight;
import io.helidon.common.config.Config;
import io.helidon.integrations.langchain4j.providers.openai.OpenAi;
import io.helidon.integrations.langchain4j.providers.openai.OpenAiImageModelConfig;
import io.helidon.service.registry.Qualifier;
import io.helidon.service.registry.Service;
import java.net.Proxy;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

@Service.Named(value="*")
@Weight(value=90.0)
@Service.Singleton
public class OpenAiImageModelFactory
implements Service.ServicesFactory<OpenAiImageModel> {
    private final Supplier<Optional<OpenAiImageModel>> model;

    OpenAiImageModelFactory(@Service.Named(value="open-ai.image-model") Supplier<Optional<Proxy>> openAiChatModelProxy, @Service.Named(value="open-ai") Supplier<Optional<Proxy>> openAiProxy, Supplier<Optional<Proxy>> proxy, Config config) {
        OpenAiImageModelConfig.Builder configBuilder = (OpenAiImageModelConfig.Builder)OpenAiImageModelConfig.builder().config(config.get("langchain4j.open-ai.image-model"));
        this.model = () -> OpenAiImageModelFactory.buildModel(configBuilder, openAiChatModelProxy, openAiProxy, proxy);
    }

    public static OpenAiImageModel create(OpenAiImageModelConfig config) {
        if (!config.enabled()) {
            throw new IllegalStateException("Cannot create a model when the configuration is disabled.");
        }
        OpenAiImageModel.OpenAiImageModelBuilder builder = OpenAiImageModel.builder();
        config.baseUrl().ifPresent(arg_0 -> ((OpenAiImageModel.OpenAiImageModelBuilder)builder).baseUrl(arg_0));
        config.apiKey().ifPresent(arg_0 -> ((OpenAiImageModel.OpenAiImageModelBuilder)builder).apiKey(arg_0));
        config.organizationId().ifPresent(arg_0 -> ((OpenAiImageModel.OpenAiImageModelBuilder)builder).organizationId(arg_0));
        config.modelName().ifPresent(arg_0 -> ((OpenAiImageModel.OpenAiImageModelBuilder)builder).modelName(arg_0));
        config.size().ifPresent(arg_0 -> ((OpenAiImageModel.OpenAiImageModelBuilder)builder).size(arg_0));
        config.quality().ifPresent(arg_0 -> ((OpenAiImageModel.OpenAiImageModelBuilder)builder).quality(arg_0));
        config.style().ifPresent(arg_0 -> ((OpenAiImageModel.OpenAiImageModelBuilder)builder).style(arg_0));
        config.user().ifPresent(arg_0 -> ((OpenAiImageModel.OpenAiImageModelBuilder)builder).user(arg_0));
        config.responseFormat().ifPresent(arg_0 -> ((OpenAiImageModel.OpenAiImageModelBuilder)builder).responseFormat(arg_0));
        config.timeout().ifPresent(arg_0 -> ((OpenAiImageModel.OpenAiImageModelBuilder)builder).timeout(arg_0));
        config.maxRetries().ifPresent(arg_0 -> ((OpenAiImageModel.OpenAiImageModelBuilder)builder).maxRetries(arg_0));
        config.logRequests().ifPresent(arg_0 -> ((OpenAiImageModel.OpenAiImageModelBuilder)builder).logRequests(arg_0));
        config.logResponses().ifPresent(arg_0 -> ((OpenAiImageModel.OpenAiImageModelBuilder)builder).logResponses(arg_0));
        config.withPersisting().ifPresent(arg_0 -> ((OpenAiImageModel.OpenAiImageModelBuilder)builder).withPersisting(arg_0));
        config.persistTo().ifPresent(arg_0 -> ((OpenAiImageModel.OpenAiImageModelBuilder)builder).persistTo(arg_0));
        config.proxy().ifPresent(arg_0 -> ((OpenAiImageModel.OpenAiImageModelBuilder)builder).proxy(arg_0));
        if (!config.customHeaders().isEmpty()) {
            builder.customHeaders(config.customHeaders());
        }
        return builder.build();
    }

    public List<Service.QualifiedInstance<OpenAiImageModel>> services() {
        Optional<OpenAiImageModel> modelOptional = this.model.get();
        if (modelOptional.isEmpty()) {
            return List.of();
        }
        OpenAiImageModel theModel = modelOptional.get();
        return List.of(Service.QualifiedInstance.create((Object)theModel, (Qualifier[])new Qualifier[0]), Service.QualifiedInstance.create((Object)theModel, (Qualifier[])new Qualifier[]{OpenAi.OPEN_AI_QUALIFIER}));
    }

    private static Optional<OpenAiImageModel> buildModel(OpenAiImageModelConfig.Builder configBuilder, Supplier<Optional<Proxy>> openAiModelProxy, Supplier<Optional<Proxy>> openAiProxy, Supplier<Optional<Proxy>> proxy) {
        if (!configBuilder.enabled()) {
            return Optional.empty();
        }
        openAiModelProxy.get().or(openAiProxy).or(proxy).ifPresent(configBuilder::proxy);
        return Optional.of(OpenAiImageModelFactory.create(configBuilder.build()));
    }
}

