/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.langchain4j.providers.openai;

import dev.langchain4j.model.Tokenizer;
import dev.langchain4j.model.openai.OpenAiStreamingChatModel;
import io.helidon.common.Weight;
import io.helidon.common.config.Config;
import io.helidon.integrations.langchain4j.providers.openai.OpenAi;
import io.helidon.integrations.langchain4j.providers.openai.OpenAiStreamingChatModelConfig;
import io.helidon.service.registry.Qualifier;
import io.helidon.service.registry.Service;
import java.net.Proxy;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

@Service.Named(value="*")
@Weight(value=90.0)
@Service.Singleton
public class OpenAiStreamingChatModelFactory
implements Service.ServicesFactory<OpenAiStreamingChatModel> {
    private final Supplier<Optional<OpenAiStreamingChatModel>> model;

    OpenAiStreamingChatModelFactory(@Service.Named(value="open-ai.streaming-chat-model") Supplier<Optional<Tokenizer>> openAiChatModelTokenizer, @Service.Named(value="open-ai") Supplier<Optional<Tokenizer>> openAiTokenizer, Supplier<Optional<Tokenizer>> tokenizer, @Service.Named(value="open-ai.streaming-chat-model") Supplier<Optional<Proxy>> openAiChatModelProxy, @Service.Named(value="open-ai") Supplier<Optional<Proxy>> openAiProxy, Supplier<Optional<Proxy>> proxy, Config config) {
        OpenAiStreamingChatModelConfig.Builder configBuilder = (OpenAiStreamingChatModelConfig.Builder)OpenAiStreamingChatModelConfig.builder().config(config.get("langchain4j.open-ai.chat-model"));
        this.model = () -> OpenAiStreamingChatModelFactory.buildModel(configBuilder, openAiChatModelTokenizer, openAiTokenizer, tokenizer, openAiChatModelProxy, openAiProxy, proxy);
    }

    public static OpenAiStreamingChatModel create(OpenAiStreamingChatModelConfig config) {
        if (!config.enabled()) {
            throw new IllegalStateException("Cannot create a model when the configuration is disabled.");
        }
        OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder builder = OpenAiStreamingChatModel.builder();
        config.baseUrl().ifPresent(arg_0 -> ((OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder)builder).baseUrl(arg_0));
        config.apiKey().ifPresent(arg_0 -> ((OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder)builder).apiKey(arg_0));
        config.organizationId().ifPresent(arg_0 -> ((OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder)builder).organizationId(arg_0));
        config.modelName().ifPresent(arg_0 -> ((OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder)builder).modelName(arg_0));
        config.temperature().ifPresent(arg_0 -> ((OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder)builder).temperature(arg_0));
        config.topP().ifPresent(arg_0 -> ((OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder)builder).topP(arg_0));
        if (!config.stop().isEmpty()) {
            builder.stop(config.stop());
        }
        config.maxTokens().ifPresent(arg_0 -> ((OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder)builder).maxTokens(arg_0));
        config.maxCompletionTokens().ifPresent(arg_0 -> ((OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder)builder).maxCompletionTokens(arg_0));
        config.presencePenalty().ifPresent(arg_0 -> ((OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder)builder).presencePenalty(arg_0));
        config.frequencyPenalty().ifPresent(arg_0 -> ((OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder)builder).frequencyPenalty(arg_0));
        if (!config.logitBias().isEmpty()) {
            builder.logitBias(config.logitBias());
        }
        config.responseFormat().ifPresent(arg_0 -> ((OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder)builder).responseFormat(arg_0));
        config.seed().ifPresent(arg_0 -> ((OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder)builder).seed(arg_0));
        config.user().ifPresent(arg_0 -> ((OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder)builder).user(arg_0));
        config.strictTools().ifPresent(arg_0 -> ((OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder)builder).strictTools(arg_0));
        config.parallelToolCalls().ifPresent(arg_0 -> ((OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder)builder).parallelToolCalls(arg_0));
        config.timeout().ifPresent(arg_0 -> ((OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder)builder).timeout(arg_0));
        config.logRequests().ifPresent(arg_0 -> ((OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder)builder).logRequests(arg_0));
        config.logResponses().ifPresent(arg_0 -> ((OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder)builder).logResponses(arg_0));
        config.tokenizer().ifPresent(arg_0 -> ((OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder)builder).tokenizer(arg_0));
        config.proxy().ifPresent(arg_0 -> ((OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder)builder).proxy(arg_0));
        if (!config.customHeaders().isEmpty()) {
            builder.customHeaders(config.customHeaders());
        }
        return builder.build();
    }

    public List<Service.QualifiedInstance<OpenAiStreamingChatModel>> services() {
        Optional<OpenAiStreamingChatModel> modelOptional = this.model.get();
        if (modelOptional.isEmpty()) {
            return List.of();
        }
        OpenAiStreamingChatModel theModel = modelOptional.get();
        return List.of(Service.QualifiedInstance.create((Object)theModel, (Qualifier[])new Qualifier[0]), Service.QualifiedInstance.create((Object)theModel, (Qualifier[])new Qualifier[]{OpenAi.OPEN_AI_QUALIFIER}));
    }

    private static Optional<OpenAiStreamingChatModel> buildModel(OpenAiStreamingChatModelConfig.Builder configBuilder, Supplier<Optional<Tokenizer>> openAiModelTokenizer, Supplier<Optional<Tokenizer>> openAiTokenizer, Supplier<Optional<Tokenizer>> tokenizer, Supplier<Optional<Proxy>> openAiModelProxy, Supplier<Optional<Proxy>> openAiProxy, Supplier<Optional<Proxy>> proxy) {
        if (!configBuilder.enabled()) {
            return Optional.empty();
        }
        openAiModelTokenizer.get().or(openAiTokenizer).or(tokenizer).ifPresent(configBuilder::tokenizer);
        openAiModelProxy.get().or(openAiProxy).or(proxy).ifPresent(configBuilder::proxy);
        return Optional.of(OpenAiStreamingChatModelFactory.create(configBuilder.build()));
    }
}

