/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.providers.micrometer;

import io.helidon.metrics.api.Gauge;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.providers.micrometer.MMeter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Tag;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;

abstract class MGauge<N extends Number>
extends MMeter<io.micrometer.core.instrument.Gauge>
implements Gauge<N> {
    private <N extends Number> MGauge(Meter.Id id, io.micrometer.core.instrument.Gauge delegate, Builder<?, N> builder) {
        super(id, delegate, builder);
    }

    private MGauge(Meter.Id id, io.micrometer.core.instrument.Gauge delegate, Optional<String> scope) {
        super(id, delegate, scope);
    }

    static <T> Builder<?, Double> builder(String name, T stateObject, ToDoubleFunction<T> fn) {
        return new FunctionBased.Builder<T>(name, stateObject, fn);
    }

    static <N extends Number> SupplierBased.Builder<N> builder(String name, Supplier<N> supplier) {
        return new SupplierBased.Builder<N>(name, supplier);
    }

    static <N extends Number> SupplierBased.Builder<N> builderFrom(Gauge.Builder<N> gBuilder) {
        return (SupplierBased.Builder)MGauge.builder(gBuilder.name(), gBuilder.supplier()).from((Meter.Builder<?, ?>)gBuilder);
    }

    static MGauge<Double> create(Meter.Id id, final io.micrometer.core.instrument.Gauge gauge, Optional<String> scope) {
        return new MGauge<Double>(id, gauge, scope){

            public Double value() {
                return gauge.value();
            }
        };
    }

    public String toString() {
        return this.stringJoiner().add("value=" + ((io.micrometer.core.instrument.Gauge)this.delegate()).value()).toString();
    }

    static class FunctionBased<T>
    extends MGauge<Double> {
        private final T stateObject;
        private final ToDoubleFunction<T> fn;

        private FunctionBased(Meter.Id id, io.micrometer.core.instrument.Gauge gauge, Builder<T> builder) {
            super(id, gauge, builder);
            this.stateObject = builder.stateObject;
            this.fn = builder.fn;
        }

        public Double value() {
            return this.fn.applyAsDouble(this.stateObject);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FunctionBased)) {
                return false;
            }
            FunctionBased that = (FunctionBased)o;
            if (!super.equals(o)) {
                return false;
            }
            return Objects.equals(this.stateObject, that.stateObject) && Objects.equals(this.fn, that.fn);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.stateObject, this.fn);
        }

        static class Builder<T>
        extends io.helidon.metrics.providers.micrometer.MGauge$Builder<Builder<T>, Double>
        implements Gauge.Builder<Double> {
            private final T stateObject;
            private final ToDoubleFunction<T> fn;

            private Builder(String name, T stateObject, ToDoubleFunction<T> fn) {
                super(name, io.micrometer.core.instrument.Gauge.builder((String)name, stateObject, fn));
                this.stateObject = stateObject;
                this.fn = fn;
                ((Gauge.Builder)this.delegate()).strongReference(true);
            }

            @Override
            protected Builder<T> delegateTags(Iterable<Tag> tags) {
                ((Gauge.Builder)this.delegate()).tags(tags);
                return (Builder)this.identity();
            }

            @Override
            protected Builder<T> delegateTag(String key, String value) {
                ((Gauge.Builder)this.delegate()).tag(key, value);
                return (Builder)this.identity();
            }

            @Override
            protected Builder<T> delegateDescription(String description) {
                ((Gauge.Builder)this.delegate()).description(description);
                return (Builder)this.identity();
            }

            @Override
            protected Builder<T> delegateBaseUnit(String baseUnit) {
                ((Gauge.Builder)this.delegate()).baseUnit(baseUnit);
                return (Builder)this.identity();
            }

            @Override
            protected MGauge<Double> build(Meter.Id id, io.micrometer.core.instrument.Gauge gauge) {
                return new FunctionBased(id, gauge, this);
            }

            public Supplier<Double> supplier() {
                return () -> this.fn.applyAsDouble(this.stateObject);
            }
        }
    }

    static class SupplierBased<N extends Number>
    extends MGauge<N> {
        private final Supplier<N> supplier;

        private SupplierBased(Meter.Id id, io.micrometer.core.instrument.Gauge gauge, Builder<N> builder) {
            super(id, gauge, builder);
            this.supplier = builder.supplier;
        }

        public N value() {
            return (N)((Number)this.supplier.get());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SupplierBased)) {
                return false;
            }
            SupplierBased that = (SupplierBased)o;
            if (!super.equals(o)) {
                return false;
            }
            return Objects.equals(this.supplier, that.supplier);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.supplier);
        }

        static class Builder<N extends Number>
        extends io.helidon.metrics.providers.micrometer.MGauge$Builder<Builder<N>, N>
        implements Gauge.Builder<N> {
            private final Supplier<N> supplier;

            private Builder(String name, Supplier<N> supplier) {
                super(name, io.micrometer.core.instrument.Gauge.builder((String)name, supplier));
                this.supplier = supplier;
            }

            @Override
            protected Builder<N> delegateTag(String key, String value) {
                ((Gauge.Builder)this.delegate()).tag(key, value);
                return (Builder)this.identity();
            }

            @Override
            protected Builder<N> delegateTags(Iterable<Tag> tags) {
                ((Gauge.Builder)this.delegate()).tags(tags);
                return (Builder)this.identity();
            }

            @Override
            protected Builder<N> delegateDescription(String description) {
                ((Gauge.Builder)this.delegate()).description(description);
                return (Builder)this.identity();
            }

            @Override
            protected Builder<N> delegateBaseUnit(String baseUnit) {
                ((Gauge.Builder)this.delegate()).baseUnit(baseUnit);
                return (Builder)this.identity();
            }

            @Override
            protected MGauge<N> build(Meter.Id id, io.micrometer.core.instrument.Gauge gauge) {
                return new SupplierBased(id, gauge, this);
            }

            public Supplier<N> supplier() {
                return this.supplier;
            }
        }
    }

    static abstract class Builder<HB extends Builder<HB, N>, N extends Number>
    extends MMeter.Builder<Gauge.Builder<?>, io.micrometer.core.instrument.Gauge, HB, MGauge<N>>
    implements Gauge.Builder<N> {
        protected Builder(String name, Gauge.Builder<?> delegate) {
            super(name, delegate);
        }

        @Override
        protected Class<? extends Meter> meterType() {
            return Gauge.class;
        }
    }
}

