/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.security;

import io.helidon.common.config.Config;
import io.helidon.microprofile.security.FeatureConfig;
import io.helidon.microprofile.security.QueryParamHandler;
import io.helidon.microprofile.security.SecurityFilter;
import io.helidon.microprofile.security.SecurityPreMatchingFilter;
import io.helidon.security.Security;
import io.helidon.security.SecurityContext;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.core.GenericType;
import java.util.LinkedList;
import java.util.List;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.inject.SupplierClassBinding;
import org.glassfish.jersey.internal.inject.SupplierInstanceBinding;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.process.internal.RequestScoped;

@ConstrainedTo(value=RuntimeType.SERVER)
public final class JerseySecurityFeature
implements Feature {
    private static final System.Logger LOGGER = System.getLogger(JerseySecurityFeature.class.getName());
    private final Security security;
    private final FeatureConfig featureConfig;

    public JerseySecurityFeature() {
        this.security = null;
        this.featureConfig = null;
    }

    public JerseySecurityFeature(Security security) {
        this.security = security;
        this.featureConfig = new FeatureConfig(JerseySecurityFeature.builder(security).config(security.configFor("jersey")));
    }

    private JerseySecurityFeature(Builder builder) {
        this.security = builder.security;
        this.featureConfig = new FeatureConfig(builder);
    }

    public static Builder builder(Security security) {
        return new Builder(security);
    }

    public boolean configure(FeatureContext context) {
        RuntimeType runtimeType = context.getConfiguration().getRuntimeType();
        if (runtimeType != RuntimeType.SERVER) {
            return false;
        }
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "Configuring Security feature in Jersey server runtime");
        }
        context.register(SecurityPreMatchingFilter.class);
        context.register(SecurityFilter.class);
        context.register((Object)new AbstractBinder(){

            protected void configure() {
                ((SupplierClassBinding)((SupplierClassBinding)((SupplierClassBinding)this.bindFactory(SecurityContextRefFactory.class).to(SecurityContext.class)).proxy(true)).proxyForSameScope(false)).in(RequestScoped.class);
                ((SupplierInstanceBinding)this.bindFactory(ReferencingFactory.referenceFactory()).to((GenericType)new GenericType<Ref<SecurityContext>>(this){})).in(RequestScoped.class);
                this.bind(JerseySecurityFeature.this.security).to(Security.class);
                this.bind(JerseySecurityFeature.this.featureConfig).to(FeatureConfig.class);
            }
        });
        return true;
    }

    FeatureConfig featureConfig() {
        return this.featureConfig;
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, JerseySecurityFeature> {
        private final Security security;
        private final List<QueryParamHandler> queryParamHandlers = new LinkedList<QueryParamHandler>();
        private boolean authorizeAnnotatedOnly = false;
        private boolean authenticateAnnotatedOnly = true;
        private boolean debug = false;
        private boolean prematchingAuthorization = false;
        private boolean prematchingAuthentication = false;
        private boolean useAbortWith = true;
        private boolean failOnFailureIfOptional = false;

        private Builder(Security security) {
            this.security = security;
        }

        public Builder authorizeAnnotatedOnly(boolean authzOnly) {
            this.authorizeAnnotatedOnly = authzOnly;
            return this;
        }

        public Builder authenticateAnnotatedOnly(boolean authnOnly) {
            this.authenticateAnnotatedOnly = authnOnly;
            return this;
        }

        public Builder addQueryParamHandler(QueryParamHandler handler) {
            this.queryParamHandlers.add(handler);
            return this;
        }

        public Builder addQueryParamHandlers(Iterable<QueryParamHandler> handlers) {
            handlers.forEach(this::addQueryParamHandler);
            return this;
        }

        public Builder usePrematchingAuthentication(boolean usePrematching) {
            this.prematchingAuthentication = usePrematching;
            return this;
        }

        public Builder usePrematchingAuthorization(boolean usePrematching) {
            this.prematchingAuthorization = usePrematching;
            return this;
        }

        private Builder failOnFailureIfOptional(Boolean failOnFailureIfOptional) {
            this.failOnFailureIfOptional = failOnFailureIfOptional;
            return this;
        }

        public Builder debug() {
            this.debug = true;
            return this;
        }

        public Builder useAbortWith(boolean useAbortWith) {
            this.useAbortWith = useAbortWith;
            return this;
        }

        public Builder config(Config config) {
            config.get("prematching-authentication").asBoolean().ifPresent(this::usePrematchingAuthentication);
            config.get("prematching-authorization").asBoolean().ifPresent(this::usePrematchingAuthorization);
            config.get("use-abort-with").asBoolean().ifPresent(this::useAbortWith);
            config.get("fail-on-failure-if-optional").asBoolean().ifPresent(this::failOnFailureIfOptional);
            Config myConfig = config.get("defaults");
            myConfig.get("authorize-annotated-only").asBoolean().ifPresent(this::authorizeAnnotatedOnly);
            myConfig.get("authenticate-annotated-only").asBoolean().ifPresent(this::authenticateAnnotatedOnly);
            myConfig.get("query-params").mapList(QueryParamHandler::create).ifPresent(this::addQueryParamHandlers);
            myConfig.get("debug").asBoolean().filter(bool -> bool).ifPresent(bool -> this.debug());
            return this;
        }

        public JerseySecurityFeature build() {
            return new JerseySecurityFeature(this);
        }

        Security security() {
            return this.security;
        }

        List<QueryParamHandler> queryParamHandlers() {
            return this.queryParamHandlers;
        }

        boolean isAuthorizeAnnotatedOnly() {
            return this.authorizeAnnotatedOnly;
        }

        boolean isAuthenticateAnnotatedOnly() {
            return this.authenticateAnnotatedOnly;
        }

        boolean isDebug() {
            return this.debug;
        }

        boolean isPrematchingAuthorization() {
            return this.prematchingAuthorization;
        }

        boolean isPrematchingAuthentication() {
            return this.prematchingAuthentication;
        }

        boolean useAbortWith() {
            return this.useAbortWith;
        }

        boolean failOnFailureIfOptional() {
            return this.failOnFailureIfOptional;
        }
    }

    private static class SecurityContextRefFactory
    extends ReferencingFactory<SecurityContext> {
        @Inject
        SecurityContextRefFactory(Provider<Ref<SecurityContext>> referenceFactory) {
            super(referenceFactory);
        }
    }
}

