/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.jwt;

import io.helidon.common.Errors;
import io.helidon.security.jwt.ClaimValidator;
import io.helidon.security.jwt.InstantValidator;
import io.helidon.security.jwt.Jwt;
import java.time.Instant;
import java.util.List;
import java.util.Optional;

public final class ExpirationValidator
extends InstantValidator {
    private ExpirationValidator(Builder builder) {
        super(builder);
    }

    public static Builder builder() {
        return (Builder)((Builder)new Builder().addClaim("exp")).addClaim("iat");
    }

    @Override
    public void validate(Jwt token, Errors.Collector collector, List<ClaimValidator> validators) {
        Optional<Instant> expirationTime = token.expirationTime();
        expirationTime.ifPresent(it -> {
            if (this.earliest().isAfter((Instant)it)) {
                collector.fatal((Object)token, "Token no longer valid, expiration: " + String.valueOf(it));
            }
            token.issueTime().ifPresent(issued -> {
                if (issued.isAfter((Instant)it)) {
                    collector.fatal((Object)token, "Token issue date is after its expiration, issue: " + String.valueOf(it) + ", expiration: " + String.valueOf(it));
                }
            });
        });
        super.validate("expirationTime", expirationTime, collector);
    }

    public static final class Builder
    extends InstantValidator.BaseBuilder<Builder, ExpirationValidator> {
        private Builder() {
        }

        public ExpirationValidator build() {
            return new ExpirationValidator(this);
        }
    }
}

