/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class ClassToInstanceStore<T> {
    private final Map<Class<? extends T>, T> backingMap = new IdentityHashMap<Class<? extends T>, T>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    @SafeVarargs
    public static <T> ClassToInstanceStore<T> create(T ... instances) {
        ClassToInstanceStore<T> result = new ClassToInstanceStore<T>();
        for (T instance : instances) {
            result.putInstance(instance);
        }
        return result;
    }

    public <U extends T> Optional<U> getInstance(Class<U> clazz) {
        this.lock.readLock().lock();
        try {
            Optional<U> optional = Optional.ofNullable(clazz.cast(this.backingMap.get(clazz)));
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <U extends T> Optional<U> putInstance(Class<? extends U> clazz, U instance) {
        this.lock.writeLock().lock();
        try {
            Optional<U> optional = Optional.ofNullable(clazz.cast(this.backingMap.put(clazz, instance)));
            return optional;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public <U extends T> Optional<U> removeInstance(Class<U> clazz) {
        this.lock.writeLock().lock();
        try {
            Optional<U> optional = Optional.ofNullable(clazz.cast(this.backingMap.remove(clazz)));
            return optional;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void putAll(ClassToInstanceStore<? extends T> toCopy) {
        this.lock.writeLock().lock();
        try {
            this.backingMap.putAll(toCopy.backingMap);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean containsKey(Class<? extends T> clazz) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.backingMap.containsKey(clazz);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.backingMap.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public <U extends T> Optional<U> putInstance(U instance) {
        this.lock.writeLock().lock();
        try {
            Optional<?> optional = this.putInstance(instance.getClass(), instance);
            return optional;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Collection<T> values() {
        this.lock.readLock().lock();
        try {
            List<T> list = List.copyOf(this.backingMap.values());
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Collection<Class<? extends T>> keys() {
        this.lock.readLock().lock();
        try {
            Set<Class<? extends T>> set = Set.copyOf(this.backingMap.keySet());
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String toString() {
        this.lock.readLock().lock();
        try {
            String string = this.backingMap.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

