/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.header;

import io.helidon.common.config.Config;
import io.helidon.security.providers.common.OutboundTarget;
import io.helidon.security.util.TokenHandler;
import java.util.Objects;
import java.util.Optional;

public class HeaderAtnOutboundConfig {
    private final Optional<TokenHandler> tokenHandler;
    private final Optional<String> explicitUser;

    private HeaderAtnOutboundConfig(Builder builder) {
        this.tokenHandler = Optional.ofNullable(builder.tokenHandler);
        this.explicitUser = Optional.ofNullable(builder.explicitUser);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static HeaderAtnOutboundConfig create() {
        return HeaderAtnOutboundConfig.builder().build();
    }

    public static HeaderAtnOutboundConfig create(Config config) {
        return HeaderAtnOutboundConfig.builder().config(config).build();
    }

    public static HeaderAtnOutboundConfig create(TokenHandler tokenHandler, String user) {
        return HeaderAtnOutboundConfig.builder().tokenHandler(tokenHandler).explicitUser(user).build();
    }

    public static HeaderAtnOutboundConfig create(OutboundTarget outboundTarget) {
        return outboundTarget.customObject(HeaderAtnOutboundConfig.class).map(HeaderAtnOutboundConfig.class::cast).or(() -> outboundTarget.getConfig().map(HeaderAtnOutboundConfig::create)).orElseGet(HeaderAtnOutboundConfig::create);
    }

    Optional<TokenHandler> tokenHandler() {
        return this.tokenHandler;
    }

    Optional<String> explicitUser() {
        return this.explicitUser;
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, HeaderAtnOutboundConfig> {
        private TokenHandler tokenHandler;
        private String explicitUser;

        private Builder() {
        }

        public HeaderAtnOutboundConfig build() {
            return new HeaderAtnOutboundConfig(this);
        }

        public Builder config(Config config) {
            config.get("outbound-token").map(TokenHandler::create).ifPresent(this::tokenHandler);
            config.get("username").asString().ifPresent(this::explicitUser);
            return this;
        }

        public Builder tokenHandler(TokenHandler tokenHandler) {
            this.tokenHandler = Objects.requireNonNull(tokenHandler);
            return this;
        }

        public Builder explicitUser(String explicitUser) {
            this.explicitUser = Objects.requireNonNull(explicitUser);
            return this;
        }
    }
}

