/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.observe.health;

import io.helidon.health.HealthCheck;
import io.helidon.health.HealthCheckResponse;
import io.helidon.http.HeaderValues;
import io.helidon.http.Headers;
import io.helidon.http.HtmlEncoder;
import io.helidon.http.Status;
import io.helidon.http.WritableHeaders;
import io.helidon.http.media.EntityWriter;
import io.helidon.http.media.jsonp.JsonpSupport;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import io.helidon.webserver.observe.health.HealthHelper;
import io.helidon.webserver.observe.health.NamedResponse;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class HealthHandler
implements Handler {
    private static final System.Logger LOGGER = System.getLogger(HealthHandler.class.getName());
    private final EntityWriter<JsonObject> entityWriter;
    private final boolean details;
    private final Collection<HealthCheck> checks;

    HealthHandler(EntityWriter<JsonObject> entityWriter, boolean details, List<HealthCheck> checks) {
        this.entityWriter = entityWriter;
        this.details = details;
        this.checks = checks;
    }

    public void handle(ServerRequest req, ServerResponse res) {
        ArrayList<NamedResponse> responses = new ArrayList<NamedResponse>();
        HealthCheckResponse.Status status = HealthCheckResponse.Status.UP;
        for (HealthCheck check : this.checks) {
            HealthCheckResponse response;
            try {
                response = check.call();
            }
            catch (Exception e) {
                response = HealthCheckResponse.builder().status(HealthCheckResponse.Status.ERROR).detail("error", (Object)e.getClass().getName()).detail("message", (Object)HtmlEncoder.encode((String)e.getMessage())).build();
                LOGGER.log(System.Logger.Level.ERROR, "Unexpected failure of health check", (Throwable)e);
            }
            responses.add(new NamedResponse(check.name(), response));
            if (response.status() == HealthCheckResponse.Status.ERROR) {
                status = HealthCheckResponse.Status.ERROR;
                continue;
            }
            if (response.status() != HealthCheckResponse.Status.DOWN || status != HealthCheckResponse.Status.UP) continue;
            status = HealthCheckResponse.Status.DOWN;
        }
        Status responseStatus = switch (status) {
            default -> throw new MatchException(null, null);
            case HealthCheckResponse.Status.UP -> {
                if (this.details) {
                    yield Status.OK_200;
                }
                yield Status.NO_CONTENT_204;
            }
            case HealthCheckResponse.Status.DOWN -> Status.SERVICE_UNAVAILABLE_503;
            case HealthCheckResponse.Status.ERROR -> Status.INTERNAL_SERVER_ERROR_500;
        };
        res.status(responseStatus);
        res.header(HeaderValues.CACHE_NO_CACHE);
        if (this.details) {
            this.entityWriter.write(JsonpSupport.JSON_OBJECT_TYPE, (Object)HealthHandler.toJson(status, responses), res.outputStream(), (Headers)req.headers(), (WritableHeaders)res.headers());
        } else {
            res.send();
        }
    }

    private static JsonObject toJson(HealthCheckResponse.Status status, List<NamedResponse> responses) {
        JsonObjectBuilder response = HealthHelper.JSON.createObjectBuilder();
        response.add("status", status.toString());
        JsonArrayBuilder checks = HealthHelper.JSON.createArrayBuilder();
        responses.forEach(result -> checks.add((JsonValue)HealthHelper.toJson(result.name(), result.response())));
        response.add("checks", checks);
        return response.build();
    }
}

