/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.api;

import io.smallrye.stork.api.MetadataKey;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;

public class Metadata<T extends Enum<T>> {
    private final EnumMap<T, Object> metadata;
    private final Class<T> clazz;
    private static final Metadata EMPTY = new Metadata<NoMetadataKey>(NoMetadataKey.class, Collections.emptyMap());

    private Metadata(Class<T> key, Map<T, Object> metadata) {
        this.metadata = metadata.isEmpty() ? new EnumMap(key) : new EnumMap<T, Object>(metadata);
        this.clazz = key;
    }

    public static <T extends Enum<T>> Metadata<T> empty() {
        return EMPTY;
    }

    public static <K extends Enum<K>> Metadata<K> of(Class<K> key, Map<K, Object> metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("`metadata` must not be `null`");
        }
        return new Metadata<K>(key, metadata);
    }

    public static <K extends Enum<K>> Metadata<K> of(Class<K> key) {
        if (key == null) {
            throw new IllegalArgumentException("`key` must not be `null`");
        }
        return new Metadata<K>(key, Collections.emptyMap());
    }

    public Metadata<T> with(T key, Object item) {
        if (key == null) {
            throw new IllegalArgumentException("`key` must not be `null`");
        }
        if (item == null) {
            throw new IllegalArgumentException(((Enum)key).name() + " should not be `null`");
        }
        EnumMap<T, Object> copy = new EnumMap<T, Object>(this.metadata);
        copy.put(key, item);
        return new Metadata<T>(this.clazz, copy);
    }

    public EnumMap<T, Object> getMetadata() {
        return this.metadata;
    }

    public static final class NoMetadataKey
    extends Enum<NoMetadataKey>
    implements MetadataKey {
        private static final /* synthetic */ NoMetadataKey[] $VALUES;

        public static NoMetadataKey[] values() {
            return (NoMetadataKey[])$VALUES.clone();
        }

        public static NoMetadataKey valueOf(String name) {
            return Enum.valueOf(NoMetadataKey.class, name);
        }

        @Override
        public String getName() {
            return null;
        }

        private static /* synthetic */ NoMetadataKey[] $values() {
            return new NoMetadataKey[0];
        }

        static {
            $VALUES = NoMetadataKey.$values();
        }
    }

    public static enum DefaultMetadataKey implements MetadataKey
    {
        GENERIC_METADATA_KEY("generic");

        private final String name;

        private DefaultMetadataKey(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

