/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.collections.prefixmap;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import nl.basjes.collections.prefixmap.PrefixTrie;

class ASCIIPrefixTrie<V extends Serializable>
implements PrefixTrie<V> {
    private final boolean caseSensitive;
    private final int charIndex;
    private ASCIIPrefixTrie<V>[] childNodes;
    private V theValue;

    ASCIIPrefixTrie(boolean caseSensitive) {
        this(caseSensitive, 0);
    }

    ASCIIPrefixTrie(boolean caseSensitive, int charIndex) {
        this.caseSensitive = caseSensitive;
        this.charIndex = charIndex;
    }

    public static void throwOnInvalidASCIIChar(int myChar) {
        if (ASCIIPrefixTrie.isInvalidASCIIChar(myChar)) {
            throw new IllegalArgumentException("Only readable ASCII is allowed as prefix !!!");
        }
    }

    public static boolean isInvalidASCIIChar(int myChar) {
        return myChar < 32 || myChar > 126;
    }

    @Override
    public V add(PrimitiveIterator.OfInt prefix, V value) {
        V previousValue = this.theValue;
        if (!prefix.hasNext()) {
            this.theValue = value;
            return previousValue;
        }
        int myChar = prefix.nextInt();
        ASCIIPrefixTrie.throwOnInvalidASCIIChar(myChar);
        if (this.childNodes == null) {
            this.childNodes = (ASCIIPrefixTrie[])Array.newInstance(ASCIIPrefixTrie.class, 128);
        }
        if (this.caseSensitive) {
            if (this.childNodes[myChar] == null) {
                this.childNodes[myChar] = new ASCIIPrefixTrie<V>(true, this.charIndex + 1);
            }
            previousValue = this.childNodes[myChar].add(prefix, value);
        } else {
            int lower = Character.toLowerCase(myChar);
            int upper = Character.toUpperCase(myChar);
            if (this.childNodes[lower] == null) {
                this.childNodes[lower] = new ASCIIPrefixTrie<V>(false, this.charIndex + 1);
            }
            previousValue = this.childNodes[lower].add(prefix, value);
            this.childNodes[upper] = this.childNodes[lower];
        }
        return previousValue;
    }

    @Override
    public V remove(PrimitiveIterator.OfInt prefix) {
        ASCIIPrefixTrie<V> child;
        if (!prefix.hasNext()) {
            V previousValue = this.theValue;
            this.theValue = null;
            return previousValue;
        }
        if (this.childNodes == null) {
            return null;
        }
        int myChar = prefix.nextInt();
        ASCIIPrefixTrie.throwOnInvalidASCIIChar(myChar);
        if (!this.caseSensitive) {
            myChar = Character.toLowerCase(myChar);
        }
        if ((child = this.childNodes[myChar]) == null) {
            return null;
        }
        return child.remove(prefix);
    }

    @Override
    public V get(PrimitiveIterator.OfInt prefix) {
        if (!prefix.hasNext()) {
            return this.theValue;
        }
        if (this.childNodes == null) {
            return null;
        }
        int myChar = prefix.nextInt();
        if (ASCIIPrefixTrie.isInvalidASCIIChar(myChar)) {
            return null;
        }
        ASCIIPrefixTrie<V> child = this.childNodes[myChar];
        if (child == null) {
            return null;
        }
        return child.get(prefix);
    }

    @Override
    public V getShortestMatch(PrimitiveIterator.OfInt input) {
        if (this.theValue != null || !input.hasNext() || this.childNodes == null) {
            return this.theValue;
        }
        int myChar = input.nextInt();
        if (ASCIIPrefixTrie.isInvalidASCIIChar(myChar)) {
            return null;
        }
        ASCIIPrefixTrie<V> child = this.childNodes[myChar];
        if (child == null) {
            return null;
        }
        return child.getShortestMatch(input);
    }

    @Override
    public V getLongestMatch(PrimitiveIterator.OfInt input) {
        if (!input.hasNext() || this.childNodes == null) {
            return this.theValue;
        }
        int myChar = input.nextInt();
        if (myChar < 32 || myChar > 126) {
            return this.theValue;
        }
        ASCIIPrefixTrie<V> child = this.childNodes[myChar];
        if (child == null) {
            return this.theValue;
        }
        V returnValue = child.getLongestMatch(input);
        return returnValue == null ? this.theValue : returnValue;
    }

    @Override
    public Iterator<V> getAllMatches(PrimitiveIterator.OfInt input) {
        return new ASCIITrieIterator(input, this);
    }

    @Override
    public void clear() {
        this.childNodes = null;
        this.theValue = null;
    }

    @Override
    public boolean caseSensitive() {
        return this.caseSensitive;
    }

    public static class ASCIITrieIterator<V extends Serializable>
    implements Iterator<V> {
        private V next;
        private final PrimitiveIterator.OfInt input;
        private ASCIIPrefixTrie<V> node;

        ASCIITrieIterator(PrimitiveIterator.OfInt input, ASCIIPrefixTrie<V> node) {
            this.input = input;
            this.node = node;
            this.next = this.getNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public V next() {
            if (this.next == null) {
                throw new NoSuchElementException("Trying next() when hasNext() is false.");
            }
            V result = this.next;
            this.next = this.getNext();
            return result;
        }

        private V getNext() {
            if (this.node == null) {
                return null;
            }
            Serializable theValue = ((ASCIIPrefixTrie)this.node).theValue;
            if (!this.input.hasNext() || ((ASCIIPrefixTrie)this.node).childNodes == null) {
                this.node = null;
                return (V)theValue;
            }
            int myChar = this.input.nextInt();
            if (myChar < 32 || myChar > 126) {
                this.node = null;
                return (V)theValue;
            }
            ASCIIPrefixTrie child = ((ASCIIPrefixTrie)this.node).childNodes[myChar];
            if (child == null) {
                this.node = null;
                return (V)theValue;
            }
            this.node = child;
            if (theValue == null) {
                return this.getNext();
            }
            return (V)theValue;
        }
    }
}

