/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal;

import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.Device;
import org.aesh.terminal.tty.Capability;
import org.aesh.terminal.tty.Point;
import org.aesh.terminal.tty.Signal;
import org.aesh.terminal.tty.Size;
import org.aesh.terminal.utils.ANSI;

public interface Connection
extends AutoCloseable {
    public Device device();

    public Size size();

    public Consumer<Size> getSizeHandler();

    public void setSizeHandler(Consumer<Size> var1);

    public Consumer<Signal> getSignalHandler();

    public void setSignalHandler(Consumer<Signal> var1);

    public Consumer<int[]> getStdinHandler();

    public void setStdinHandler(Consumer<int[]> var1);

    public Consumer<int[]> stdoutHandler();

    public void setCloseHandler(Consumer<Void> var1);

    public Consumer<Void> getCloseHandler();

    @Override
    public void close();

    default public void close(int exit) {
        this.close();
    }

    public void openBlocking();

    public void openNonBlocking();

    public boolean put(Capability var1, Object ... var2);

    public Attributes getAttributes();

    public void setAttributes(Attributes var1);

    public Charset inputEncoding();

    public Charset outputEncoding();

    public boolean supportsAnsi();

    default public Connection write(String s) {
        int[] codePoints = s.codePoints().toArray();
        this.stdoutHandler().accept(codePoints);
        return this;
    }

    default public Attributes enterRawMode() {
        Attributes prvAttr = this.getAttributes();
        Attributes newAttr = new Attributes(prvAttr);
        newAttr.setLocalFlags(EnumSet.of(Attributes.LocalFlag.ICANON, Attributes.LocalFlag.ECHO, Attributes.LocalFlag.IEXTEN), false);
        newAttr.setInputFlags(EnumSet.of(Attributes.InputFlag.IXON, Attributes.InputFlag.ICRNL, Attributes.InputFlag.INLCR), false);
        newAttr.setControlChar(Attributes.ControlChar.VMIN, 1);
        newAttr.setControlChar(Attributes.ControlChar.VTIME, 0);
        newAttr.setControlChar(Attributes.ControlChar.VINTR, 0);
        this.setAttributes(newAttr);
        return prvAttr;
    }

    default public Point getCursorPosition() {
        Consumer<int[]> prevInputHandler = this.getStdinHandler();
        CountDownLatch latch = new CountDownLatch(1);
        Point[] p = new Point[]{null};
        Attributes attributes = this.enterRawMode();
        this.setStdinHandler(ints -> {
            p[0] = ANSI.getActualCursor(ints);
            this.setStdinHandler(prevInputHandler);
            latch.countDown();
            this.setAttributes(attributes);
        });
        this.stdoutHandler().accept("\u001b[6n".codePoints().toArray());
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return p[0];
    }
}

