/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.elasticsearch.table;

import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.connector.elasticsearch.sink.ElasticsearchEmitter;
import org.apache.flink.connector.elasticsearch.sink.RequestIndexer;
import org.apache.flink.connector.elasticsearch.table.IndexGenerator;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.Preconditions;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.common.xcontent.XContentType;

class RowElasticsearchEmitter
implements ElasticsearchEmitter<RowData> {
    private final IndexGenerator indexGenerator;
    private final SerializationSchema<RowData> serializationSchema;
    private final XContentType contentType;
    @Nullable
    private final String documentType;
    private final Function<RowData, String> createKey;

    public RowElasticsearchEmitter(IndexGenerator indexGenerator, SerializationSchema<RowData> serializationSchema, XContentType contentType, @Nullable String documentType, Function<RowData, String> createKey) {
        this.indexGenerator = (IndexGenerator)Preconditions.checkNotNull((Object)indexGenerator);
        this.serializationSchema = (SerializationSchema)Preconditions.checkNotNull(serializationSchema);
        this.contentType = (XContentType)Preconditions.checkNotNull((Object)contentType);
        this.documentType = documentType;
        this.createKey = (Function)Preconditions.checkNotNull(createKey);
    }

    @Override
    public void open() {
        this.indexGenerator.open();
    }

    @Override
    public void emit(RowData element, SinkWriter.Context context, RequestIndexer indexer) {
        switch (element.getRowKind()) {
            case INSERT: 
            case UPDATE_AFTER: {
                this.processUpsert(element, indexer);
                break;
            }
            case UPDATE_BEFORE: 
            case DELETE: {
                this.processDelete(element, indexer);
                break;
            }
            default: {
                throw new TableException("Unsupported message kind: " + element.getRowKind());
            }
        }
    }

    private void processUpsert(RowData row, RequestIndexer indexer) {
        byte[] document = this.serializationSchema.serialize((Object)row);
        String key = this.createKey.apply(row);
        if (key != null) {
            UpdateRequest updateRequest = new UpdateRequest(this.indexGenerator.generate(row), this.documentType, key).doc(document, this.contentType).upsert(document, this.contentType);
            indexer.add(updateRequest);
        } else {
            IndexRequest indexRequest = new IndexRequest(this.indexGenerator.generate(row), this.documentType).id(key).source(document, this.contentType);
            indexer.add(indexRequest);
        }
    }

    private void processDelete(RowData row, RequestIndexer indexer) {
        String key = this.createKey.apply(row);
        DeleteRequest deleteRequest = new DeleteRequest(this.indexGenerator.generate(row), this.documentType, key);
        indexer.add(deleteRequest);
    }
}

