/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc.util;

import java.io.IOException;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hadoop.conf.Configuration;
import org.apache.orc.ColumnStatistics;
import org.apache.orc.DateColumnStatistics;
import org.apache.orc.DecimalColumnStatistics;
import org.apache.orc.DoubleColumnStatistics;
import org.apache.orc.IntegerColumnStatistics;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.StringColumnStatistics;
import org.apache.orc.TimestampColumnStatistics;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.ColumnStatisticsImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcFormatStatisticsReportUtil {
    private static final Logger LOG = LoggerFactory.getLogger(OrcFormatStatisticsReportUtil.class);

    public static TableStats getTableStatistics(List<Path> files, DataType producedDataType, Configuration hadoopConfig) {
        try {
            long rowCount = 0L;
            HashMap<String, ColumnStatistics> columnStatisticsMap = new HashMap<String, ColumnStatistics>();
            RowType producedRowType = (RowType)producedDataType.getLogicalType();
            for (Path file : files) {
                rowCount += OrcFormatStatisticsReportUtil.updateStatistics(hadoopConfig, file, columnStatisticsMap, producedRowType);
            }
            Map<String, ColumnStats> columnStatsMap = OrcFormatStatisticsReportUtil.convertToColumnStats(rowCount, columnStatisticsMap, producedRowType);
            return new TableStats(rowCount, columnStatsMap);
        }
        catch (Exception e) {
            LOG.warn("Reporting statistics failed for Orc format: {}", (Object)e.getMessage());
            return TableStats.UNKNOWN;
        }
    }

    private static long updateStatistics(Configuration hadoopConf, Path file, Map<String, ColumnStatistics> columnStatisticsMap, RowType producedRowType) throws IOException {
        org.apache.hadoop.fs.Path path = new org.apache.hadoop.fs.Path(file.toUri());
        Reader reader = OrcFile.createReader((org.apache.hadoop.fs.Path)path, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)hadoopConf).maxLength(OrcConf.MAX_FILE_LENGTH.getLong(hadoopConf)));
        ColumnStatistics[] statistics = reader.getStatistics();
        TypeDescription schema = reader.getSchema();
        List fieldNames = schema.getFieldNames();
        List columnTypes = schema.getChildren();
        for (String column : producedRowType.getFieldNames()) {
            int fieldIdx = fieldNames.indexOf(column);
            if (fieldIdx < 0) continue;
            int colId = ((TypeDescription)columnTypes.get(fieldIdx)).getId();
            ColumnStatistics statistic = statistics[colId];
            OrcFormatStatisticsReportUtil.updateStatistics(statistic, column, columnStatisticsMap);
        }
        return reader.getNumberOfRows();
    }

    private static void updateStatistics(ColumnStatistics statistic, String column, Map<String, ColumnStatistics> columnStatisticsMap) {
        ColumnStatistics previousStatistics = columnStatisticsMap.get(column);
        if (previousStatistics == null) {
            columnStatisticsMap.put(column, statistic);
        } else if (previousStatistics instanceof ColumnStatisticsImpl) {
            ((ColumnStatisticsImpl)previousStatistics).merge((ColumnStatisticsImpl)statistic);
        }
    }

    private static Map<String, ColumnStats> convertToColumnStats(long totalRowCount, Map<String, ColumnStatistics> columnStatisticsMap, RowType logicalType) {
        HashMap<String, ColumnStats> columnStatsMap = new HashMap<String, ColumnStats>();
        for (String column : logicalType.getFieldNames()) {
            ColumnStatistics columnStatistics = columnStatisticsMap.get(column);
            if (columnStatistics == null) continue;
            ColumnStats columnStats = OrcFormatStatisticsReportUtil.convertToColumnStats(totalRowCount, logicalType.getTypeAt(logicalType.getFieldIndex(column)), columnStatistics);
            columnStatsMap.put(column, columnStats);
        }
        return columnStatsMap;
    }

    private static ColumnStats convertToColumnStats(long totalRowCount, LogicalType logicalType, ColumnStatistics columnStatistics) {
        ColumnStats.Builder builder = new ColumnStats.Builder().setNdv(null).setAvgLen(null).setMaxLen(null);
        if (!columnStatistics.hasNull()) {
            builder.setNullCount(Long.valueOf(0L));
        } else {
            builder.setNullCount(Long.valueOf(totalRowCount - columnStatistics.getNumberOfValues()));
        }
        switch (logicalType.getTypeRoot()) {
            case BOOLEAN: {
                break;
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                if (columnStatistics instanceof IntegerColumnStatistics) {
                    builder.setMax((Comparable)Long.valueOf(((IntegerColumnStatistics)columnStatistics).getMaximum())).setMin((Comparable)Long.valueOf(((IntegerColumnStatistics)columnStatistics).getMinimum()));
                    break;
                }
                return null;
            }
            case FLOAT: 
            case DOUBLE: {
                if (columnStatistics instanceof DoubleColumnStatistics) {
                    builder.setMax((Comparable)Double.valueOf(((DoubleColumnStatistics)columnStatistics).getMaximum())).setMin((Comparable)Double.valueOf(((DoubleColumnStatistics)columnStatistics).getMinimum()));
                    break;
                }
                return null;
            }
            case CHAR: 
            case VARCHAR: {
                if (columnStatistics instanceof StringColumnStatistics) {
                    builder.setMax((Comparable)((Object)((StringColumnStatistics)columnStatistics).getMaximum())).setMin((Comparable)((Object)((StringColumnStatistics)columnStatistics).getMinimum()));
                    break;
                }
                return null;
            }
            case DATE: {
                if (columnStatistics instanceof DateColumnStatistics) {
                    Date maximum = (Date)((DateColumnStatistics)columnStatistics).getMaximum();
                    Date minimum = (Date)((DateColumnStatistics)columnStatistics).getMinimum();
                    builder.setMax((Comparable)maximum).setMin((Comparable)minimum);
                    break;
                }
                return null;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_TIME_ZONE: {
                if (columnStatistics instanceof TimestampColumnStatistics) {
                    builder.setMax((Comparable)((TimestampColumnStatistics)columnStatistics).getMaximum()).setMin((Comparable)((TimestampColumnStatistics)columnStatistics).getMinimum());
                    break;
                }
                return null;
            }
            case DECIMAL: {
                if (columnStatistics instanceof DecimalColumnStatistics) {
                    builder.setMax((Comparable)((DecimalColumnStatistics)columnStatistics).getMaximum().bigDecimalValue()).setMin((Comparable)((DecimalColumnStatistics)columnStatistics).getMinimum().bigDecimalValue());
                    break;
                }
                return null;
            }
            default: {
                return null;
            }
        }
        return builder.build();
    }
}

