/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint.component;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.dispatcher.runner.DispatcherRunner;
import org.apache.flink.runtime.dispatcher.runner.TestingDispatcherRunner;
import org.apache.flink.runtime.entrypoint.component.DispatcherResourceManagerComponent;
import org.apache.flink.runtime.entrypoint.component.TestingResourceManagerService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.leaderretrieval.SettableLeaderRetrievalService;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.util.TestingFatalErrorHandler;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class DispatcherResourceManagerComponentTest
extends TestLogger {
    @Test
    public void unexpectedResourceManagerTermination_failsFatally() {
        CompletableFuture<Void> terminationFuture = new CompletableFuture<Void>();
        TestingFatalErrorHandler fatalErrorHandler = new TestingFatalErrorHandler();
        TestingResourceManagerService resourceManagerService = TestingResourceManagerService.newBuilder().setTerminationFuture(terminationFuture).build();
        this.createDispatcherResourceManagerComponent(fatalErrorHandler, resourceManagerService);
        FlinkException expectedException = new FlinkException("Expected test exception.");
        terminationFuture.completeExceptionally((Throwable)expectedException);
        Throwable error = fatalErrorHandler.getException();
        Assert.assertThat((Object)error, (Matcher)FlinkMatchers.containsCause((Throwable)expectedException));
    }

    private DispatcherResourceManagerComponent createDispatcherResourceManagerComponent(TestingFatalErrorHandler fatalErrorHandler, TestingResourceManagerService resourceManagerService) {
        return new DispatcherResourceManagerComponent((DispatcherRunner)TestingDispatcherRunner.newBuilder().build(), (DispatcherResourceManagerComponent.ResourceManagerService)resourceManagerService, (LeaderRetrievalService)new SettableLeaderRetrievalService(), (LeaderRetrievalService)new SettableLeaderRetrievalService(), FutureUtils::completedVoidFuture, (FatalErrorHandler)fatalErrorHandler);
    }

    @Test
    public void unexpectedResourceManagerTermination_ifNotRunning_doesNotFailFatally() {
        TestingFatalErrorHandler fatalErrorHandler = new TestingFatalErrorHandler();
        CompletableFuture<Void> terminationFuture = new CompletableFuture<Void>();
        TestingResourceManagerService resourceManagerService = TestingResourceManagerService.newBuilder().setTerminationFuture(terminationFuture).withManualTerminationFutureCompletion().build();
        DispatcherResourceManagerComponent dispatcherResourceManagerComponent = this.createDispatcherResourceManagerComponent(fatalErrorHandler, resourceManagerService);
        dispatcherResourceManagerComponent.closeAsync();
        FlinkException expectedException = new FlinkException("Expected test exception.");
        terminationFuture.completeExceptionally((Throwable)expectedException);
        CompletableFuture<Throwable> errorFuture = fatalErrorHandler.getErrorFuture();
        Assert.assertThat(errorFuture, (Matcher)FlinkMatchers.willNotComplete((Duration)Duration.ofMillis(10L)));
    }
}

