/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.runtime.client.JobInitializationException;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.jobmaster.DefaultJobMasterServiceProcess;
import org.apache.flink.runtime.jobmaster.JobManagerRunnerResult;
import org.apache.flink.runtime.jobmaster.JobMasterService;
import org.apache.flink.runtime.jobmaster.JobNotFinishedException;
import org.apache.flink.runtime.jobmaster.TestingJobMasterService;
import org.apache.flink.runtime.jobmaster.factories.JobMasterServiceFactory;
import org.apache.flink.runtime.jobmaster.factories.TestingJobMasterServiceFactory;
import org.apache.flink.runtime.jobmaster.utils.TestingJobMasterGateway;
import org.apache.flink.runtime.jobmaster.utils.TestingJobMasterGatewayBuilder;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionGraphBuilder;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class DefaultJobMasterServiceProcessTest
extends TestLogger {
    private static final Duration TIMEOUT = Duration.ofSeconds(10L);
    private static final JobID jobId = new JobID();
    private static final Function<Throwable, ArchivedExecutionGraph> failedArchivedExecutionGraphFactory = throwable -> ArchivedExecutionGraph.createFromInitializingJob((JobID)jobId, (String)"test", (JobStatus)JobStatus.FAILED, (Throwable)throwable, null, (long)1337L);

    @Test
    public void testInitializationFailureCompletesResultFuture() {
        CompletableFuture<JobMasterService> jobMasterServiceFuture = new CompletableFuture<JobMasterService>();
        DefaultJobMasterServiceProcess serviceProcess = this.createTestInstance(jobMasterServiceFuture);
        RuntimeException originalCause = new RuntimeException("Init error");
        jobMasterServiceFuture.completeExceptionally(originalCause);
        Assert.assertTrue((boolean)((JobManagerRunnerResult)serviceProcess.getResultFuture().join()).isInitializationFailure());
        Throwable initializationFailure = ((JobManagerRunnerResult)serviceProcess.getResultFuture().join()).getInitializationFailure();
        Assert.assertThat((Object)initializationFailure, (Matcher)FlinkMatchers.containsCause(JobInitializationException.class));
        Assert.assertThat((Object)initializationFailure, (Matcher)FlinkMatchers.containsCause((Throwable)originalCause));
    }

    @Test
    public void testCloseAfterInitializationFailure() throws Exception {
        CompletableFuture<JobMasterService> jobMasterServiceFuture = new CompletableFuture<JobMasterService>();
        DefaultJobMasterServiceProcess serviceProcess = this.createTestInstance(jobMasterServiceFuture);
        jobMasterServiceFuture.completeExceptionally(new RuntimeException("Init error"));
        serviceProcess.closeAsync().get();
        Assert.assertTrue((boolean)((JobManagerRunnerResult)serviceProcess.getResultFuture().join()).isInitializationFailure());
        Assert.assertThat((Object)serviceProcess.getJobMasterGatewayFuture().isCompletedExceptionally(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testCloseAfterInitializationSuccess() throws Exception {
        CompletableFuture<JobMasterService> jobMasterServiceFuture = new CompletableFuture<JobMasterService>();
        DefaultJobMasterServiceProcess serviceProcess = this.createTestInstance(jobMasterServiceFuture);
        TestingJobMasterService testingJobMasterService = new TestingJobMasterService();
        jobMasterServiceFuture.complete(testingJobMasterService);
        serviceProcess.closeAsync().get();
        Assert.assertThat((Object)testingJobMasterService.isClosed(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)serviceProcess.getResultFuture(), (Matcher)FlinkMatchers.futureWillCompleteExceptionally(JobNotFinishedException.class, (Duration)TIMEOUT));
    }

    @Test
    public void testJobMasterTerminationIsHandled() {
        CompletableFuture<JobMasterService> jobMasterServiceFuture = new CompletableFuture<JobMasterService>();
        DefaultJobMasterServiceProcess serviceProcess = this.createTestInstance(jobMasterServiceFuture);
        CompletableFuture<Void> jobMasterTerminationFuture = new CompletableFuture<Void>();
        TestingJobMasterService testingJobMasterService = new TestingJobMasterService("localhost", jobMasterTerminationFuture, null);
        jobMasterServiceFuture.complete(testingJobMasterService);
        RuntimeException testException = new RuntimeException("Fake exception from JobMaster");
        jobMasterTerminationFuture.completeExceptionally(testException);
        try {
            serviceProcess.getResultFuture().get();
            Assert.fail((String)"Expect failure");
        }
        catch (Throwable t) {
            Assert.assertThat((Object)t, (Matcher)FlinkMatchers.containsCause(RuntimeException.class));
            Assert.assertThat((Object)t, (Matcher)FlinkMatchers.containsMessage((String)testException.getMessage()));
        }
    }

    @Test
    public void testJobMasterGatewayGetsForwarded() throws Exception {
        CompletableFuture<JobMasterService> jobMasterServiceFuture = new CompletableFuture<JobMasterService>();
        DefaultJobMasterServiceProcess serviceProcess = this.createTestInstance(jobMasterServiceFuture);
        TestingJobMasterGateway testingGateway = new TestingJobMasterGatewayBuilder().build();
        TestingJobMasterService testingJobMasterService = new TestingJobMasterService("localhost", null, testingGateway);
        jobMasterServiceFuture.complete(testingJobMasterService);
        Assert.assertThat(serviceProcess.getJobMasterGatewayFuture().get(), (Matcher)CoreMatchers.is((Object)testingGateway));
    }

    @Test
    public void testLeaderAddressGetsForwarded() throws Exception {
        CompletableFuture<JobMasterService> jobMasterServiceFuture = new CompletableFuture<JobMasterService>();
        DefaultJobMasterServiceProcess serviceProcess = this.createTestInstance(jobMasterServiceFuture);
        String testingAddress = "yolohost";
        TestingJobMasterService testingJobMasterService = new TestingJobMasterService(testingAddress, null, null);
        jobMasterServiceFuture.complete(testingJobMasterService);
        Assert.assertThat(serviceProcess.getLeaderAddressFuture().get(), (Matcher)CoreMatchers.is((Object)testingAddress));
    }

    @Test
    public void testIsNotInitialized() {
        DefaultJobMasterServiceProcess serviceProcess = this.createTestInstance(new CompletableFuture<JobMasterService>());
        Assert.assertThat((Object)serviceProcess.isInitializedAndRunning(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testIsInitialized() {
        CompletableFuture<JobMasterService> jobMasterServiceFuture = new CompletableFuture<JobMasterService>();
        DefaultJobMasterServiceProcess serviceProcess = this.createTestInstance(jobMasterServiceFuture);
        jobMasterServiceFuture.complete(new TestingJobMasterService());
        Assert.assertThat((Object)serviceProcess.isInitializedAndRunning(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testIsNotInitializedAfterClosing() {
        CompletableFuture<JobMasterService> jobMasterServiceFuture = new CompletableFuture<JobMasterService>();
        DefaultJobMasterServiceProcess serviceProcess = this.createTestInstance(jobMasterServiceFuture);
        jobMasterServiceFuture.complete(new TestingJobMasterService());
        serviceProcess.closeAsync();
        Assert.assertFalse((boolean)serviceProcess.isInitializedAndRunning());
    }

    @Test
    public void testSuccessOnTerminalState() throws Exception {
        CompletableFuture<JobMasterService> jobMasterServiceFuture = new CompletableFuture<JobMasterService>();
        DefaultJobMasterServiceProcess serviceProcess = this.createTestInstance(jobMasterServiceFuture);
        jobMasterServiceFuture.complete(new TestingJobMasterService());
        ArchivedExecutionGraph archivedExecutionGraph = new ArchivedExecutionGraphBuilder().setState(JobStatus.FINISHED).build();
        serviceProcess.jobReachedGloballyTerminalState(new ExecutionGraphInfo(archivedExecutionGraph));
        Assert.assertThat((Object)((JobManagerRunnerResult)serviceProcess.getResultFuture().get()).isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((JobManagerRunnerResult)serviceProcess.getResultFuture().get()).getExecutionGraphInfo().getArchivedExecutionGraph().getState(), (Matcher)CoreMatchers.is((Object)JobStatus.FINISHED));
    }

    @Test
    public void testJobFinishedByOther() {
        CompletableFuture<JobMasterService> jobMasterServiceFuture = new CompletableFuture<JobMasterService>();
        DefaultJobMasterServiceProcess serviceProcess = this.createTestInstance(jobMasterServiceFuture);
        jobMasterServiceFuture.complete(new TestingJobMasterService());
        serviceProcess.jobFinishedByOther();
        Assert.assertThat((Object)serviceProcess.getResultFuture(), (Matcher)FlinkMatchers.futureWillCompleteExceptionally(JobNotFinishedException.class, (Duration)TIMEOUT));
    }

    private DefaultJobMasterServiceProcess createTestInstance(CompletableFuture<JobMasterService> jobMasterServiceFuture) {
        return new DefaultJobMasterServiceProcess(jobId, UUID.randomUUID(), (JobMasterServiceFactory)new TestingJobMasterServiceFactory(() -> jobMasterServiceFuture), failedArchivedExecutionGraphFactory);
    }
}

