/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.management;

import java.lang.management.ManagementFactory;
import java.util.Optional;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.flink.runtime.management.JMXServer;
import org.apache.flink.runtime.management.JMXService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JMXServerTest {
    @Before
    public void setUp() throws Exception {
        JMXService.startInstance((String)"23456-23466");
    }

    @After
    public void tearDown() throws Exception {
        JMXService.stopInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJMXServiceRegisterMBean() throws Exception {
        TestObject testObject = new TestObject();
        ObjectName testObjectName = new ObjectName("org.apache.flink.management", "key", "value");
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            Optional server = JMXService.getInstance();
            Assert.assertTrue((boolean)server.isPresent());
            mBeanServer.registerMBean(testObject, testObjectName);
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi://localhost:" + ((JMXServer)server.get()).getPort() + "/jndi/rmi://localhost:" + ((JMXServer)server.get()).getPort() + "/jmxrmi");
            JMXConnector jmxConn = JMXConnectorFactory.connect(url);
            MBeanServerConnection mbeanConnConn = jmxConn.getMBeanServerConnection();
            Assert.assertEquals((Object)1, (Object)mbeanConnConn.getAttribute(testObjectName, "Foo"));
            mBeanServer.unregisterMBean(testObjectName);
            try {
                mbeanConnConn.getAttribute(testObjectName, "Foo");
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof InstanceNotFoundException));
            }
        }
        finally {
            JMXService.stopInstance();
        }
    }

    public static class TestObject
    implements TestObjectMBean {
        private int foo = 1;

        @Override
        public int getFoo() {
            return this.foo;
        }
    }

    public static interface TestObjectMBean {
        public int getFoo();
    }
}

