/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.ResourceManagerOptions;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerConfiguration;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class SlotManagerConfigurationTest
extends TestLogger {
    @Test
    public void testSetSlotRequestTimeout() throws Exception {
        long slotIdleTimeout = 42L;
        Configuration configuration = new Configuration();
        configuration.setLong(JobManagerOptions.SLOT_REQUEST_TIMEOUT, 42L);
        SlotManagerConfiguration slotManagerConfiguration = SlotManagerConfiguration.fromConfiguration((Configuration)configuration, (WorkerResourceSpec)WorkerResourceSpec.ZERO);
        Assert.assertThat((Object)slotManagerConfiguration.getSlotRequestTimeout().toMilliseconds(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)42L)));
    }

    @Test
    public void testPreferLegacySlotRequestTimeout() throws Exception {
        long legacySlotIdleTimeout = 42L;
        Configuration configuration = new Configuration();
        configuration.setLong(ResourceManagerOptions.SLOT_REQUEST_TIMEOUT, 42L);
        configuration.setLong(JobManagerOptions.SLOT_REQUEST_TIMEOUT, 300000L);
        SlotManagerConfiguration slotManagerConfiguration = SlotManagerConfiguration.fromConfiguration((Configuration)configuration, (WorkerResourceSpec)WorkerResourceSpec.ZERO);
        Assert.assertThat((Object)slotManagerConfiguration.getSlotRequestTimeout().toMilliseconds(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)42L)));
    }
}

