/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.utils;

import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.concurrent.ScheduledExecutorServiceAdapter;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.heartbeat.TestingHeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.TestingHighAvailabilityServices;
import org.apache.flink.runtime.leaderelection.TestingLeaderElectionService;
import org.apache.flink.runtime.resourcemanager.DefaultJobLeaderIdService;
import org.apache.flink.runtime.resourcemanager.JobLeaderIdService;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerBuilder;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.testutils.DirectScheduledExecutorService;
import org.apache.flink.util.Preconditions;

public class MockResourceManagerRuntimeServices {
    public final RpcService rpcService;
    public final Time timeout;
    public final TestingHighAvailabilityServices highAvailabilityServices;
    public final HeartbeatServices heartbeatServices;
    public final TestingLeaderElectionService rmLeaderElectionService;
    public final JobLeaderIdService jobLeaderIdService;
    public final SlotManager slotManager;

    public MockResourceManagerRuntimeServices(RpcService rpcService, Time timeout) {
        this(rpcService, timeout, (SlotManager)SlotManagerBuilder.newBuilder().setScheduledExecutor((ScheduledExecutor)new ScheduledExecutorServiceAdapter((ScheduledExecutorService)new DirectScheduledExecutorService())).setTaskManagerRequestTimeout(Time.seconds((long)10L)).setSlotRequestTimeout(Time.seconds((long)10L)).setTaskManagerTimeout(Time.minutes((long)1L)).build());
    }

    public MockResourceManagerRuntimeServices(RpcService rpcService, Time timeout, SlotManager slotManager) {
        this.rpcService = (RpcService)Preconditions.checkNotNull((Object)rpcService);
        this.timeout = (Time)Preconditions.checkNotNull((Object)timeout);
        this.slotManager = slotManager;
        this.highAvailabilityServices = new TestingHighAvailabilityServices();
        this.rmLeaderElectionService = new TestingLeaderElectionService();
        this.highAvailabilityServices.setResourceManagerLeaderElectionService(this.rmLeaderElectionService);
        this.heartbeatServices = new TestingHeartbeatServices();
        this.jobLeaderIdService = new DefaultJobLeaderIdService((HighAvailabilityServices)this.highAvailabilityServices, rpcService.getScheduledExecutor(), Time.minutes((long)5L));
    }

    public void grantLeadership() throws Exception {
        UUID rmLeaderSessionId = UUID.randomUUID();
        this.rmLeaderElectionService.isLeader(rmLeaderSessionId).get(this.timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
    }

    public void revokeLeadership() {
        this.rmLeaderElectionService.notLeader();
    }
}

