/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.net.SSLUtilsTest;
import org.apache.flink.runtime.rest.RestClientConfiguration;
import org.apache.flink.runtime.rest.RestServerEndpointConfiguration;
import org.apache.flink.runtime.rest.RestServerEndpointITCase;
import org.apache.flink.runtime.rest.handler.RestHandlerSpecification;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.util.TestRestServerEndpoint;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.TestingRestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInboundHandler;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RestServerSSLAuthITCase
extends TestLogger {
    private static final String KEY_STORE_FILE = RestServerSSLAuthITCase.class.getResource("/local127.keystore").getFile();
    private static final String TRUST_STORE_FILE = RestServerSSLAuthITCase.class.getResource("/local127.truststore").getFile();
    private static final String UNTRUSTED_KEY_STORE_FILE = RestServerSSLAuthITCase.class.getResource("/untrusted.keystore").getFile();
    private static final Time timeout = Time.seconds((long)10L);
    private final Configuration clientConfig;
    private final Configuration serverConfig;

    public RestServerSSLAuthITCase(Tuple2<Configuration, Configuration> clinetServerConfig) {
        this.clientConfig = (Configuration)clinetServerConfig.f0;
        this.serverConfig = (Configuration)clinetServerConfig.f1;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() throws Exception {
        Tuple2<Configuration, Configuration> untrusted = RestServerSSLAuthITCase.getClientServerConfiguration();
        Configuration serverConfig = new Configuration((Configuration)untrusted.f1);
        serverConfig.setString(SecurityOptions.SSL_REST_TRUSTSTORE, TRUST_STORE_FILE);
        serverConfig.setString(SecurityOptions.SSL_REST_CERT_FINGERPRINT, SSLUtilsTest.getRestCertificateFingerprint(serverConfig, "flink.test").replaceAll("[0-9A-Z]", "0"));
        Configuration clientConfig = new Configuration((Configuration)untrusted.f0);
        clientConfig.setString(SecurityOptions.SSL_REST_TRUSTSTORE, TRUST_STORE_FILE);
        Tuple2 withFingerprint = Tuple2.of((Object)clientConfig, (Object)serverConfig);
        return Arrays.asList({untrusted}, {withFingerprint});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectFailure() throws Exception {
        RestServerEndpointITCase.TestRestClient restClient = null;
        TestRestServerEndpoint serverEndpoint = null;
        try {
            RestServerEndpointConfiguration restServerConfig = RestServerEndpointConfiguration.fromConfiguration((Configuration)this.serverConfig);
            RestClientConfiguration restClientConfig = RestClientConfiguration.fromConfiguration((Configuration)this.clientConfig);
            TestingRestfulGateway restfulGateway = new TestingRestfulGateway.Builder().build();
            RestServerEndpointITCase.TestVersionHandler testVersionHandler = new RestServerEndpointITCase.TestVersionHandler((GatewayRetriever<? extends RestfulGateway>)((GatewayRetriever)() -> CompletableFuture.completedFuture(restfulGateway)), RpcUtils.INF_TIMEOUT);
            serverEndpoint = TestRestServerEndpoint.builder(restServerConfig).withHandler((RestHandlerSpecification)testVersionHandler.getMessageHeaders(), (ChannelInboundHandler)testVersionHandler).buildAndStart();
            restClient = new RestServerEndpointITCase.TestRestClient(restClientConfig);
            CompletableFuture response = restClient.sendRequest(serverEndpoint.getServerAddress().getHostName(), serverEndpoint.getServerAddress().getPort(), RestServerEndpointITCase.TestVersionHeaders.INSTANCE, (MessageParameters)EmptyMessageParameters.getInstance(), (RequestBody)EmptyRequestBody.getInstance(), Collections.emptyList());
            response.get(60L, TimeUnit.SECONDS);
            Assert.fail((String)"should never complete normally");
        }
        catch (ExecutionException exception) {
            Assert.assertTrue((boolean)ExceptionUtils.findThrowable((Throwable)exception, SSLException.class).isPresent());
        }
        finally {
            if (restClient != null) {
                restClient.shutdown(timeout);
            }
            if (serverEndpoint != null) {
                serverEndpoint.close();
            }
        }
    }

    private static Tuple2<Configuration, Configuration> getClientServerConfiguration() {
        Configuration baseConfig = new Configuration();
        baseConfig.setString(RestOptions.BIND_PORT, "0");
        baseConfig.setString(RestOptions.ADDRESS, "localhost");
        baseConfig.setBoolean(SecurityOptions.SSL_REST_ENABLED, true);
        baseConfig.setBoolean(SecurityOptions.SSL_REST_AUTHENTICATION_ENABLED, true);
        baseConfig.setString(SecurityOptions.SSL_ALGORITHMS, "TLS_RSA_WITH_AES_128_CBC_SHA");
        Configuration serverConfig = new Configuration(baseConfig);
        serverConfig.setString(SecurityOptions.SSL_REST_TRUSTSTORE, TRUST_STORE_FILE);
        serverConfig.setString(SecurityOptions.SSL_REST_TRUSTSTORE_PASSWORD, "password");
        serverConfig.setString(SecurityOptions.SSL_REST_KEYSTORE, KEY_STORE_FILE);
        serverConfig.setString(SecurityOptions.SSL_REST_KEYSTORE_PASSWORD, "password");
        serverConfig.setString(SecurityOptions.SSL_REST_KEY_PASSWORD, "password");
        Configuration clientConfig = new Configuration(baseConfig);
        clientConfig.setString(SecurityOptions.SSL_REST_TRUSTSTORE, UNTRUSTED_KEY_STORE_FILE);
        clientConfig.setString(SecurityOptions.SSL_REST_TRUSTSTORE_PASSWORD, "password");
        clientConfig.setString(SecurityOptions.SSL_REST_KEYSTORE, KEY_STORE_FILE);
        clientConfig.setString(SecurityOptions.SSL_REST_KEYSTORE_PASSWORD, "password");
        clientConfig.setString(SecurityOptions.SSL_REST_KEY_PASSWORD, "password");
        return Tuple2.of((Object)clientConfig, (Object)serverConfig);
    }
}

