/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.akka;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.rpc.akka.AkkaRpcActorTest;
import org.apache.flink.runtime.rpc.akka.AkkaRpcService;
import org.apache.flink.runtime.rpc.akka.AkkaRpcServiceUtils;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class RemoteAkkaRpcActorTest
extends TestLogger {
    private static AkkaRpcService rpcService;
    private static AkkaRpcService otherRpcService;

    @BeforeClass
    public static void setupClass() throws Exception {
        Configuration configuration = new Configuration();
        rpcService = AkkaRpcServiceUtils.createRemoteRpcService((Configuration)configuration, (String)"localhost", (String)"0", null, Optional.empty());
        otherRpcService = AkkaRpcServiceUtils.createRemoteRpcService((Configuration)configuration, (String)"localhost", (String)"0", null, Optional.empty());
    }

    @AfterClass
    public static void teardownClass() throws InterruptedException, ExecutionException, TimeoutException {
        RpcUtils.terminateRpcServices((Time)Time.seconds((long)10L), (RpcService[])new RpcService[]{rpcService, otherRpcService});
    }

    @Test
    public void canRespondWithNullValueRemotely() throws Exception {
        try (AkkaRpcActorTest.NullRespondingEndpoint nullRespondingEndpoint = new AkkaRpcActorTest.NullRespondingEndpoint((RpcService)rpcService);){
            nullRespondingEndpoint.start();
            AkkaRpcActorTest.NullRespondingGateway rpcGateway = (AkkaRpcActorTest.NullRespondingGateway)otherRpcService.connect(nullRespondingEndpoint.getAddress(), AkkaRpcActorTest.NullRespondingGateway.class).join();
            CompletableFuture<Integer> nullValuedResponseFuture = rpcGateway.foobar();
            Assert.assertThat((Object)nullValuedResponseFuture.join(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
    }

    @Test
    public void canRespondWithSynchronousNullValueRemotely() throws Exception {
        try (AkkaRpcActorTest.NullRespondingEndpoint nullRespondingEndpoint = new AkkaRpcActorTest.NullRespondingEndpoint((RpcService)rpcService);){
            nullRespondingEndpoint.start();
            AkkaRpcActorTest.NullRespondingGateway rpcGateway = (AkkaRpcActorTest.NullRespondingGateway)otherRpcService.connect(nullRespondingEndpoint.getAddress(), AkkaRpcActorTest.NullRespondingGateway.class).join();
            Integer value = rpcGateway.synchronousFoobar();
            Assert.assertThat((Object)value, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
    }

    @Test
    public void canRespondWithSerializedValueRemotely() throws Exception {
        try (AkkaRpcActorTest.SerializedValueRespondingEndpoint endpoint = new AkkaRpcActorTest.SerializedValueRespondingEndpoint((RpcService)rpcService);){
            endpoint.start();
            AkkaRpcActorTest.SerializedValueRespondingGateway remoteGateway = (AkkaRpcActorTest.SerializedValueRespondingGateway)otherRpcService.connect(endpoint.getAddress(), AkkaRpcActorTest.SerializedValueRespondingGateway.class).join();
            Assert.assertThat(remoteGateway.getSerializedValueSynchronously(), (Matcher)Matchers.equalTo(AkkaRpcActorTest.SerializedValueRespondingEndpoint.SERIALIZED_VALUE));
            CompletableFuture<SerializedValue<String>> responseFuture = remoteGateway.getSerializedValue();
            Assert.assertThat(responseFuture.get(), (Matcher)Matchers.equalTo(AkkaRpcActorTest.SerializedValueRespondingEndpoint.SERIALIZED_VALUE));
        }
    }
}

