/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.exceptionhistory;

import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.scheduler.exceptionhistory.ArchivedTaskManagerLocationMatcher;
import org.apache.flink.runtime.scheduler.exceptionhistory.ExceptionHistoryEntry;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ExceptionHistoryEntryTest
extends TestLogger {
    @Test
    public void testCreate() {
        RuntimeException failure = new RuntimeException("Expected exception");
        long timestamp = System.currentTimeMillis();
        LocalTaskManagerLocation taskManagerLocation = new LocalTaskManagerLocation();
        TestAccessExecution execution = new TestAccessExecution(new ExecutionAttemptID(), failure, timestamp, taskManagerLocation);
        String taskName = "task name";
        ExceptionHistoryEntry entry = ExceptionHistoryEntry.create((AccessExecution)execution, (String)"task name");
        Assert.assertThat((Object)entry.getException().deserializeError(ClassLoader.getSystemClassLoader()), (Matcher)CoreMatchers.is((Object)failure));
        Assert.assertThat((Object)entry.getTimestamp(), (Matcher)CoreMatchers.is((Object)timestamp));
        Assert.assertThat((Object)entry.getFailingTaskName(), (Matcher)CoreMatchers.is((Object)"task name"));
        Assert.assertThat((Object)entry.getTaskManagerLocation(), ArchivedTaskManagerLocationMatcher.isArchivedTaskManagerLocation(taskManagerLocation));
        Assert.assertThat((Object)entry.isGlobal(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreationFailure() {
        ExceptionHistoryEntry.create((AccessExecution)TestAccessExecution.createExecutionWithoutFailure(new ExecutionAttemptID(), new LocalTaskManagerLocation()), (String)"task name");
    }

    @Test(expected=NullPointerException.class)
    public void testNullExecution() {
        ExceptionHistoryEntry.create(null, (String)"task name");
    }

    @Test(expected=NullPointerException.class)
    public void testNullTaskName() {
        ExceptionHistoryEntry.create((AccessExecution)new TestAccessExecution(new ExecutionAttemptID(), new Exception("Expected failure"), System.currentTimeMillis(), new LocalTaskManagerLocation()), null);
    }

    @Test
    public void testWithMissingTaskManagerLocation() {
        Exception failure = new Exception("Expected failure");
        long timestamp = System.currentTimeMillis();
        String taskName = "task name";
        ExceptionHistoryEntry entry = ExceptionHistoryEntry.create((AccessExecution)new TestAccessExecution(new ExecutionAttemptID(), failure, timestamp, null), (String)"task name");
        Assert.assertThat((Object)entry.getException().deserializeError(ClassLoader.getSystemClassLoader()), (Matcher)CoreMatchers.is((Object)failure));
        Assert.assertThat((Object)entry.getTimestamp(), (Matcher)CoreMatchers.is((Object)timestamp));
        Assert.assertThat((Object)entry.getFailingTaskName(), (Matcher)CoreMatchers.is((Object)"task name"));
        Assert.assertThat((Object)entry.getTaskManagerLocation(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)entry.isGlobal(), (Matcher)CoreMatchers.is((Object)false));
    }

    private static class TestAccessExecution
    implements AccessExecution {
        private final ExecutionAttemptID executionAttemptID;
        private final ErrorInfo failureInfo;
        private final TaskManagerLocation taskManagerLocation;

        private static TestAccessExecution createExecutionWithoutFailure(ExecutionAttemptID executionAttemptID, TaskManagerLocation taskManagerLocation) {
            return new TestAccessExecution(executionAttemptID, null, 0L, taskManagerLocation);
        }

        private TestAccessExecution(ExecutionAttemptID executionAttemptID, @Nullable Throwable failure, long timestamp, TaskManagerLocation taskManagerLocation) {
            this.executionAttemptID = executionAttemptID;
            this.failureInfo = failure == null ? null : new ErrorInfo(failure, timestamp);
            this.taskManagerLocation = taskManagerLocation;
        }

        public ExecutionAttemptID getAttemptId() {
            return this.executionAttemptID;
        }

        public TaskManagerLocation getAssignedResourceLocation() {
            return this.taskManagerLocation;
        }

        public Optional<ErrorInfo> getFailureInfo() {
            return Optional.ofNullable(this.failureInfo);
        }

        public int getAttemptNumber() {
            throw new UnsupportedOperationException("getAttemptNumber should not be called.");
        }

        public long[] getStateTimestamps() {
            throw new UnsupportedOperationException("getStateTimestamps should not be called.");
        }

        public ExecutionState getState() {
            throw new UnsupportedOperationException("getState should not be called.");
        }

        public long getStateTimestamp(ExecutionState state) {
            throw new UnsupportedOperationException("getStateTimestamp should not be called.");
        }

        public StringifiedAccumulatorResult[] getUserAccumulatorsStringified() {
            throw new UnsupportedOperationException("getUserAccumulatorsStringified should not be called.");
        }

        public int getParallelSubtaskIndex() {
            throw new UnsupportedOperationException("getParallelSubtaskIndex should not be called.");
        }

        public IOMetrics getIOMetrics() {
            throw new UnsupportedOperationException("getIOMetrics should not be called.");
        }
    }
}

