/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.exceptionhistory;

import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.client.JobExecutionException;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.TaskExecutionStateTransition;
import org.apache.flink.runtime.executiongraph.TestingDefaultExecutionGraphBuilder;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphTestUtils;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlotBuilder;
import org.apache.flink.runtime.scheduler.exceptionhistory.ExceptionHistoryEntryMatcher;
import org.apache.flink.runtime.scheduler.exceptionhistory.FailureHandlingResultSnapshot;
import org.apache.flink.runtime.scheduler.exceptionhistory.RootExceptionHistoryEntry;
import org.apache.flink.runtime.taskmanager.TaskExecutionState;
import org.apache.flink.shaded.guava18.com.google.common.collect.Iterables;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RootExceptionHistoryEntryTest
extends TestLogger {
    private ExecutionGraph executionGraph;

    @Before
    public void setup() throws JobException, JobExecutionException {
        JobGraph jobGraph = JobGraphTestUtils.singleNoOpJobGraph();
        jobGraph.getVertices().forEach(v -> v.setParallelism(3));
        this.executionGraph = TestingDefaultExecutionGraphBuilder.newBuilder().setJobGraph(jobGraph).build();
        this.executionGraph.start(ComponentMainThreadExecutorServiceAdapter.forMainThread());
    }

    @Test
    public void testFromFailureHandlingResultSnapshot() {
        RuntimeException rootException = new RuntimeException("Expected root failure");
        ExecutionVertex rootExecutionVertex = this.extractExecutionVertex(0);
        long rootTimestamp = this.triggerFailure(rootExecutionVertex, rootException);
        IllegalStateException concurrentException = new IllegalStateException("Expected other failure");
        ExecutionVertex concurrentlyFailedExecutionVertex = this.extractExecutionVertex(1);
        long concurrentExceptionTimestamp = this.triggerFailure(concurrentlyFailedExecutionVertex, concurrentException);
        FailureHandlingResultSnapshot snapshot = new FailureHandlingResultSnapshot(rootExecutionVertex.getCurrentExecutionAttempt(), (Throwable)rootException, rootTimestamp, Collections.singleton(concurrentlyFailedExecutionVertex.getCurrentExecutionAttempt()));
        RootExceptionHistoryEntry actualEntry = RootExceptionHistoryEntry.fromFailureHandlingResultSnapshot((FailureHandlingResultSnapshot)snapshot);
        Assert.assertThat((Object)actualEntry, ExceptionHistoryEntryMatcher.matchesFailure(rootException, rootTimestamp, rootExecutionVertex.getTaskNameWithSubtaskIndex(), rootExecutionVertex.getCurrentAssignedResourceLocation()));
        Assert.assertThat((Object)actualEntry.getConcurrentExceptions(), (Matcher)IsIterableContainingInOrder.contains(ExceptionHistoryEntryMatcher.matchesFailure(concurrentException, concurrentExceptionTimestamp, concurrentlyFailedExecutionVertex.getTaskNameWithSubtaskIndex(), concurrentlyFailedExecutionVertex.getCurrentAssignedResourceLocation())));
    }

    @Test
    public void testFromGlobalFailure() {
        RuntimeException concurrentException0 = new RuntimeException("Expected concurrent failure #0");
        ExecutionVertex concurrentlyFailedExecutionVertex0 = this.extractExecutionVertex(0);
        long concurrentExceptionTimestamp0 = this.triggerFailure(concurrentlyFailedExecutionVertex0, concurrentException0);
        IllegalStateException concurrentException1 = new IllegalStateException("Expected concurrent failure #1");
        ExecutionVertex concurrentlyFailedExecutionVertex1 = this.extractExecutionVertex(1);
        long concurrentExceptionTimestamp1 = this.triggerFailure(concurrentlyFailedExecutionVertex1, concurrentException1);
        Exception rootCause = new Exception("Expected root failure");
        long rootTimestamp = System.currentTimeMillis();
        RootExceptionHistoryEntry actualEntry = RootExceptionHistoryEntry.fromGlobalFailure((Throwable)rootCause, (long)rootTimestamp, (Iterable)StreamSupport.stream(this.executionGraph.getAllExecutionVertices().spliterator(), false).map(ExecutionVertex::getCurrentExecutionAttempt).collect(Collectors.toSet()));
        Assert.assertThat((Object)actualEntry, ExceptionHistoryEntryMatcher.matchesGlobalFailure(rootCause, rootTimestamp));
        Assert.assertThat((Object)actualEntry.getConcurrentExceptions(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Matcher[])new Matcher[]{ExceptionHistoryEntryMatcher.matchesFailure(concurrentException0, concurrentExceptionTimestamp0, concurrentlyFailedExecutionVertex0.getTaskNameWithSubtaskIndex(), concurrentlyFailedExecutionVertex0.getCurrentAssignedResourceLocation()), ExceptionHistoryEntryMatcher.matchesFailure(concurrentException1, concurrentExceptionTimestamp1, concurrentlyFailedExecutionVertex1.getTaskNameWithSubtaskIndex(), concurrentlyFailedExecutionVertex1.getCurrentAssignedResourceLocation())}));
    }

    private long triggerFailure(ExecutionVertex executionVertex, Throwable throwable) {
        this.executionGraph.updateState(new TaskExecutionStateTransition(new TaskExecutionState(executionVertex.getCurrentExecutionAttempt().getAttemptId(), ExecutionState.FAILED, throwable)));
        return ((ErrorInfo)executionVertex.getFailureInfo().orElseThrow(() -> new IllegalArgumentException("The transition into failed state didn't succeed for ExecutionVertex " + executionVertex.getID() + "."))).getTimestamp();
    }

    private ExecutionVertex extractExecutionVertex(int pos) {
        ExecutionVertex executionVertex = (ExecutionVertex)Iterables.get((Iterable)this.executionGraph.getAllExecutionVertices(), (int)pos);
        executionVertex.tryAssignResource((LogicalSlot)new TestingLogicalSlotBuilder().createTestingLogicalSlot());
        return executionVertex;
    }
}

