/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.taskexecutor.TaskExecutorMemoryConfiguration;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class TaskExecutorMemoryConfigurationTest
extends TestLogger {
    @Test
    public void testInitializationWithAllValuesBeingSet() {
        Configuration config = new Configuration();
        config.set(TaskManagerOptions.FRAMEWORK_HEAP_MEMORY, (Object)new MemorySize(1L));
        config.set(TaskManagerOptions.TASK_HEAP_MEMORY, (Object)new MemorySize(2L));
        config.set(TaskManagerOptions.FRAMEWORK_OFF_HEAP_MEMORY, (Object)new MemorySize(3L));
        config.set(TaskManagerOptions.TASK_OFF_HEAP_MEMORY, (Object)new MemorySize(4L));
        config.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)new MemorySize(5L));
        config.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)new MemorySize(6L));
        config.set(TaskManagerOptions.NETWORK_MEMORY_FRACTION, (Object)Float.valueOf(0.1f));
        config.set(TaskManagerOptions.MANAGED_MEMORY_SIZE, (Object)new MemorySize(7L));
        config.set(TaskManagerOptions.MANAGED_MEMORY_FRACTION, (Object)Float.valueOf(0.2f));
        config.set(TaskManagerOptions.JVM_METASPACE, (Object)new MemorySize(8L));
        config.set(TaskManagerOptions.JVM_OVERHEAD_MIN, (Object)new MemorySize(9L));
        config.set(TaskManagerOptions.JVM_OVERHEAD_MAX, (Object)new MemorySize(10L));
        config.set(TaskManagerOptions.JVM_OVERHEAD_FRACTION, (Object)Float.valueOf(0.3f));
        config.set(TaskManagerOptions.TOTAL_FLINK_MEMORY, (Object)new MemorySize(11L));
        config.set(TaskManagerOptions.TOTAL_PROCESS_MEMORY, (Object)new MemorySize(12L));
        TaskExecutorMemoryConfiguration actual = TaskExecutorMemoryConfiguration.create((Configuration)config);
        TaskExecutorMemoryConfiguration expected = new TaskExecutorMemoryConfiguration(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L), Long.valueOf(6L), Long.valueOf(7L), Long.valueOf(8L), Long.valueOf(10L), Long.valueOf(11L), Long.valueOf(12L));
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)expected));
    }

    @Test
    public void testInitializationWithMissingValues() {
        Configuration config = new Configuration();
        TaskExecutorMemoryConfiguration actual = TaskExecutorMemoryConfiguration.create((Configuration)config);
        TaskExecutorMemoryConfiguration expected = new TaskExecutorMemoryConfiguration(Long.valueOf(((MemorySize)TaskManagerOptions.FRAMEWORK_HEAP_MEMORY.defaultValue()).getBytes()), null, Long.valueOf(((MemorySize)TaskManagerOptions.FRAMEWORK_OFF_HEAP_MEMORY.defaultValue()).getBytes()), Long.valueOf(((MemorySize)TaskManagerOptions.TASK_OFF_HEAP_MEMORY.defaultValue()).getBytes()), Long.valueOf(((MemorySize)TaskManagerOptions.NETWORK_MEMORY_MAX.defaultValue()).getBytes()), null, Long.valueOf(((MemorySize)TaskManagerOptions.JVM_METASPACE.defaultValue()).getBytes()), Long.valueOf(((MemorySize)TaskManagerOptions.JVM_OVERHEAD_MAX.defaultValue()).getBytes()), null, null);
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)expected));
    }
}

