/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.api.common.resources.ExternalResource;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExternalResourceOptions;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceSpec;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceUtils;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TaskExecutorResourceUtilsTest
extends TestLogger {
    private static final double CPU_CORES = 1.0;
    private static final MemorySize TASK_HEAP = MemorySize.ofMebiBytes((long)1L);
    private static final MemorySize TASK_OFF_HEAP = MemorySize.ofMebiBytes((long)2L);
    private static final MemorySize NETWORK = MemorySize.ofMebiBytes((long)3L);
    private static final MemorySize MANAGED = MemorySize.ofMebiBytes((long)4L);
    private static final String EXTERNAL_RESOURCE_NAME = "test";
    private static final long EXTERNAL_RESOURCE_AMOUNT = 1L;

    @Test
    public void testResourceSpecFromConfig() {
        TaskExecutorResourceSpec resourceSpec = TaskExecutorResourceUtils.resourceSpecFromConfig((Configuration)TaskExecutorResourceUtilsTest.createValidConfig());
        Assert.assertThat((Object)resourceSpec.getCpuCores(), (Matcher)CoreMatchers.is((Object)new CPUResource(1.0)));
        Assert.assertThat((Object)resourceSpec.getTaskHeapSize(), (Matcher)CoreMatchers.is((Object)TASK_HEAP));
        Assert.assertThat((Object)resourceSpec.getTaskOffHeapSize(), (Matcher)CoreMatchers.is((Object)TASK_OFF_HEAP));
        Assert.assertThat((Object)resourceSpec.getNetworkMemSize(), (Matcher)CoreMatchers.is((Object)NETWORK));
        Assert.assertThat((Object)resourceSpec.getManagedMemorySize(), (Matcher)CoreMatchers.is((Object)MANAGED));
        Assert.assertThat((Object)((ExternalResource)resourceSpec.getExtendedResources().get(EXTERNAL_RESOURCE_NAME)).getValue().longValue(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test(expected=IllegalConfigurationException.class)
    public void testResourceSpecFromConfigFailsIfNetworkSizeIsNotFixed() {
        Configuration configuration = TaskExecutorResourceUtilsTest.createValidConfig();
        configuration.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)MemorySize.ofMebiBytes((long)1L));
        configuration.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)MemorySize.ofMebiBytes((long)2L));
        TaskExecutorResourceUtils.resourceSpecFromConfig((Configuration)configuration);
    }

    @Test
    public void testResourceSpecFromConfigFailsIfRequiredOptionIsNotSet() {
        TaskExecutorResourceUtils.CONFIG_OPTIONS.stream().filter(option -> !option.hasDefaultValue()).forEach(option -> {
            try {
                TaskExecutorResourceUtils.resourceSpecFromConfig((Configuration)TaskExecutorResourceUtilsTest.setAllRequiredOptionsExceptOne(option));
                Assert.fail((String)("should fail with " + IllegalConfigurationException.class.getSimpleName()));
            }
            catch (IllegalConfigurationException illegalConfigurationException) {
                // empty catch block
            }
        });
    }

    @Test
    public void testAdjustForLocalExecution() {
        Configuration configuration = TaskExecutorResourceUtils.adjustForLocalExecution((Configuration)new Configuration());
        Assert.assertThat((Object)configuration.get(TaskManagerOptions.NETWORK_MEMORY_MIN), (Matcher)CoreMatchers.is((Object)TaskExecutorResourceUtils.DEFAULT_SHUFFLE_MEMORY_SIZE));
        Assert.assertThat((Object)configuration.get(TaskManagerOptions.NETWORK_MEMORY_MAX), (Matcher)CoreMatchers.is((Object)TaskExecutorResourceUtils.DEFAULT_SHUFFLE_MEMORY_SIZE));
        Assert.assertThat((Object)configuration.get(TaskManagerOptions.MANAGED_MEMORY_SIZE), (Matcher)CoreMatchers.is((Object)TaskExecutorResourceUtils.DEFAULT_MANAGED_MEMORY_SIZE));
    }

    @Test
    public void testNetworkMinAdjustForLocalExecutionIfMaxSet() {
        MemorySize networkMemorySize = MemorySize.ofMebiBytes((long)1L);
        Configuration configuration = new Configuration();
        configuration.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)networkMemorySize);
        TaskExecutorResourceUtils.adjustForLocalExecution((Configuration)configuration);
        Assert.assertThat((Object)configuration.get(TaskManagerOptions.NETWORK_MEMORY_MIN), (Matcher)CoreMatchers.is((Object)networkMemorySize));
        Assert.assertThat((Object)configuration.get(TaskManagerOptions.NETWORK_MEMORY_MAX), (Matcher)CoreMatchers.is((Object)networkMemorySize));
    }

    @Test
    public void testNetworkMaxAdjustForLocalExecutionIfMinSet() {
        MemorySize networkMemorySize = MemorySize.ofMebiBytes((long)1L);
        Configuration configuration = new Configuration();
        configuration.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)networkMemorySize);
        TaskExecutorResourceUtils.adjustForLocalExecution((Configuration)configuration);
        Assert.assertThat((Object)configuration.get(TaskManagerOptions.NETWORK_MEMORY_MIN), (Matcher)CoreMatchers.is((Object)networkMemorySize));
        Assert.assertThat((Object)configuration.get(TaskManagerOptions.NETWORK_MEMORY_MAX), (Matcher)CoreMatchers.is((Object)networkMemorySize));
    }

    private static Configuration createValidConfig() {
        Configuration configuration = new Configuration();
        configuration.set(TaskManagerOptions.CPU_CORES, (Object)1.0);
        configuration.set(TaskManagerOptions.TASK_HEAP_MEMORY, (Object)TASK_HEAP);
        configuration.set(TaskManagerOptions.TASK_OFF_HEAP_MEMORY, (Object)TASK_OFF_HEAP);
        configuration.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)NETWORK);
        configuration.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)NETWORK);
        configuration.set(TaskManagerOptions.MANAGED_MEMORY_SIZE, (Object)MANAGED);
        configuration.setString(ExternalResourceOptions.EXTERNAL_RESOURCE_LIST.key(), EXTERNAL_RESOURCE_NAME);
        configuration.setString(ExternalResourceOptions.getAmountConfigOptionForResource((String)EXTERNAL_RESOURCE_NAME), String.valueOf(1L));
        return configuration;
    }

    private static Configuration setAllRequiredOptionsExceptOne(ConfigOption<?> optionToNotSet) {
        Configuration configuration = new Configuration();
        if (!TaskManagerOptions.CPU_CORES.equals(optionToNotSet)) {
            configuration.set(TaskManagerOptions.CPU_CORES, (Object)1.0);
        }
        MemorySize network = MemorySize.ofMebiBytes((long)3L);
        configuration.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)network);
        configuration.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)network);
        TaskExecutorResourceUtils.CONFIG_OPTIONS.stream().filter(option -> !option.equals((Object)TaskManagerOptions.CPU_CORES)).filter(option -> !option.equals((Object)optionToNotSet)).forEach(option -> configuration.set(option, (Object)MemorySize.ofMebiBytes((long)1L)));
        return configuration;
    }
}

