/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.contrib.streaming.state.RocksDBProperty;

public class RocksDBNativeMetricOptions
implements Serializable {
    public static final ConfigOption<Boolean> MONITOR_NUM_IMMUTABLE_MEM_TABLES = ConfigOptions.key((String)RocksDBProperty.NumImmutableMemTable.getConfigKey()).defaultValue((Object)false).withDescription("Monitor the number of immutable memtables in RocksDB.");
    public static final ConfigOption<Boolean> MONITOR_MEM_TABLE_FLUSH_PENDING = ConfigOptions.key((String)RocksDBProperty.MemTableFlushPending.getConfigKey()).defaultValue((Object)false).withDescription("Monitor the number of pending memtable flushes in RocksDB.");
    public static final ConfigOption<Boolean> TRACK_COMPACTION_PENDING = ConfigOptions.key((String)RocksDBProperty.CompactionPending.getConfigKey()).defaultValue((Object)false).withDescription("Track pending compactions in RocksDB. Returns 1 if a compaction is pending, 0 otherwise.");
    public static final ConfigOption<Boolean> MONITOR_BACKGROUND_ERRORS = ConfigOptions.key((String)RocksDBProperty.BackgroundErrors.getConfigKey()).defaultValue((Object)false).withDescription("Monitor the number of background errors in RocksDB.");
    public static final ConfigOption<Boolean> MONITOR_CUR_SIZE_ACTIVE_MEM_TABLE = ConfigOptions.key((String)RocksDBProperty.CurSizeActiveMemTable.getConfigKey()).defaultValue((Object)false).withDescription("Monitor the approximate size of the active memtable in bytes.");
    public static final ConfigOption<Boolean> MONITOR_CUR_SIZE_ALL_MEM_TABLE = ConfigOptions.key((String)RocksDBProperty.CurSizeAllMemTables.getConfigKey()).defaultValue((Object)false).withDescription("Monitor the approximate size of the active and unflushed immutable memtables in bytes.");
    public static final ConfigOption<Boolean> MONITOR_SIZE_ALL_MEM_TABLES = ConfigOptions.key((String)RocksDBProperty.SizeAllMemTables.getConfigKey()).defaultValue((Object)false).withDescription("Monitor the approximate size of the active, unflushed immutable, and pinned immutable memtables in bytes.");
    public static final ConfigOption<Boolean> MONITOR_NUM_ENTRIES_ACTIVE_MEM_TABLE = ConfigOptions.key((String)RocksDBProperty.NumEntriesActiveMemTable.getConfigKey()).defaultValue((Object)false).withDescription("Monitor the total number of entries in the active memtable.");
    public static final ConfigOption<Boolean> MONITOR_NUM_ENTRIES_IMM_MEM_TABLES = ConfigOptions.key((String)RocksDBProperty.NumEntriesImmMemTables.getConfigKey()).defaultValue((Object)false).withDescription("Monitor the total number of entries in the unflushed immutable memtables.");
    public static final ConfigOption<Boolean> MONITOR_NUM_DELETES_ACTIVE_MEM_TABLE = ConfigOptions.key((String)RocksDBProperty.NumDeletesActiveMemTable.getConfigKey()).defaultValue((Object)false).withDescription("Monitor the total number of delete entries in the active memtable.");
    public static final ConfigOption<Boolean> MONITOR_NUM_DELETES_IMM_MEM_TABLE = ConfigOptions.key((String)RocksDBProperty.NumDeletesImmMemTables.getConfigKey()).defaultValue((Object)false).withDescription("Monitor the total number of delete entries in the unflushed immutable memtables.");
    public static final ConfigOption<Boolean> ESTIMATE_NUM_KEYS = ConfigOptions.key((String)RocksDBProperty.EstimateNumKeys.getConfigKey()).defaultValue((Object)false).withDescription("Estimate the number of keys in RocksDB.");
    public static final ConfigOption<Boolean> ESTIMATE_TABLE_READERS_MEM = ConfigOptions.key((String)RocksDBProperty.EstimateTableReadersMem.getConfigKey()).defaultValue((Object)false).withDescription("Estimate the memory used for reading SST tables, excluding memory used in block cache (e.g.,filter and index blocks) in bytes.");
    public static final ConfigOption<Boolean> MONITOR_NUM_SNAPSHOTS = ConfigOptions.key((String)RocksDBProperty.NumSnapshots.getConfigKey()).defaultValue((Object)false).withDescription("Monitor the number of unreleased snapshots of the database.");
    public static final ConfigOption<Boolean> MONITOR_NUM_LIVE_VERSIONS = ConfigOptions.key((String)RocksDBProperty.NumLiveVersions.getConfigKey()).defaultValue((Object)false).withDescription("Monitor number of live versions. Version is an internal data structure. See RocksDB file version_set.h for details. More live versions often mean more SST files are held from being deleted, by iterators or unfinished compactions.");
    public static final ConfigOption<Boolean> ESTIMATE_LIVE_DATA_SIZE = ConfigOptions.key((String)RocksDBProperty.EstimateLiveDataSize.getConfigKey()).defaultValue((Object)false).withDescription("Estimate of the amount of live data in bytes.");
    public static final ConfigOption<Boolean> MONITOR_TOTAL_SST_FILES_SIZE = ConfigOptions.key((String)RocksDBProperty.TotalSstFilesSize.getConfigKey()).defaultValue((Object)false).withDescription("Monitor the total size (bytes) of all SST files.WARNING: may slow down online queries if there are too many files.");
    public static final ConfigOption<Boolean> ESTIMATE_PENDING_COMPACTION_BYTES = ConfigOptions.key((String)RocksDBProperty.EstimatePendingCompactionBytes.getConfigKey()).defaultValue((Object)false).withDescription("Estimated total number of bytes compaction needs to rewrite to get all levels down to under target size. Not valid for other compactions than level-based.");
    public static final ConfigOption<Boolean> MONITOR_NUM_RUNNING_COMPACTIONS = ConfigOptions.key((String)RocksDBProperty.NumRunningCompactions.getConfigKey()).defaultValue((Object)false).withDescription("Monitor the number of currently running compactions.");
    public static final ConfigOption<Boolean> MONITOR_NUM_RUNNING_FLUSHES = ConfigOptions.key((String)RocksDBProperty.NumRunningFlushes.getConfigKey()).defaultValue((Object)false).withDescription("Monitor the number of currently running flushes.");
    public static final ConfigOption<Boolean> MONITOR_ACTUAL_DELAYED_WRITE_RATE = ConfigOptions.key((String)RocksDBProperty.ActualDelayedWriteRate.getConfigKey()).defaultValue((Object)false).withDescription("Monitor the current actual delayed write rate. 0 means no delay.");
    private Set<String> properties = new HashSet<String>();

    public static RocksDBNativeMetricOptions fromConfig(Configuration config) {
        RocksDBNativeMetricOptions options = new RocksDBNativeMetricOptions();
        if (config.getBoolean(MONITOR_NUM_IMMUTABLE_MEM_TABLES)) {
            options.enableNumImmutableMemTable();
        }
        if (config.getBoolean(MONITOR_MEM_TABLE_FLUSH_PENDING)) {
            options.enableMemTableFlushPending();
        }
        if (config.getBoolean(TRACK_COMPACTION_PENDING)) {
            options.enableCompactionPending();
        }
        if (config.getBoolean(MONITOR_BACKGROUND_ERRORS)) {
            options.enableBackgroundErrors();
        }
        if (config.getBoolean(MONITOR_CUR_SIZE_ACTIVE_MEM_TABLE)) {
            options.enableCurSizeActiveMemTable();
        }
        if (config.getBoolean(MONITOR_CUR_SIZE_ALL_MEM_TABLE)) {
            options.enableCurSizeAllMemTables();
        }
        if (config.getBoolean(MONITOR_SIZE_ALL_MEM_TABLES)) {
            options.enableSizeAllMemTables();
        }
        if (config.getBoolean(MONITOR_NUM_ENTRIES_ACTIVE_MEM_TABLE)) {
            options.enableNumEntriesActiveMemTable();
        }
        if (config.getBoolean(MONITOR_NUM_ENTRIES_IMM_MEM_TABLES)) {
            options.enableNumEntriesImmMemTables();
        }
        if (config.getBoolean(MONITOR_NUM_DELETES_ACTIVE_MEM_TABLE)) {
            options.enableNumDeletesActiveMemTable();
        }
        if (config.getBoolean(MONITOR_NUM_DELETES_IMM_MEM_TABLE)) {
            options.enableNumDeletesImmMemTables();
        }
        if (config.getBoolean(ESTIMATE_NUM_KEYS)) {
            options.enableEstimateNumKeys();
        }
        if (config.getBoolean(ESTIMATE_TABLE_READERS_MEM)) {
            options.enableEstimateTableReadersMem();
        }
        if (config.getBoolean(MONITOR_NUM_SNAPSHOTS)) {
            options.enableNumSnapshots();
        }
        if (config.getBoolean(MONITOR_NUM_LIVE_VERSIONS)) {
            options.enableNumLiveVersions();
        }
        if (config.getBoolean(ESTIMATE_LIVE_DATA_SIZE)) {
            options.enableEstimateLiveDataSize();
        }
        if (config.getBoolean(MONITOR_TOTAL_SST_FILES_SIZE)) {
            options.enableTotalSstFilesSize();
        }
        if (config.getBoolean(ESTIMATE_PENDING_COMPACTION_BYTES)) {
            options.enableEstimatePendingCompactionBytes();
        }
        if (config.getBoolean(MONITOR_NUM_RUNNING_COMPACTIONS)) {
            options.enableNumRunningCompactions();
        }
        if (config.getBoolean(MONITOR_NUM_RUNNING_FLUSHES)) {
            options.enableNumRunningFlushes();
        }
        if (config.getBoolean(MONITOR_ACTUAL_DELAYED_WRITE_RATE)) {
            options.enableActualDelayedWriteRate();
        }
        return options;
    }

    public void enableNumImmutableMemTable() {
        this.properties.add(RocksDBProperty.NumImmutableMemTable.getRocksDBProperty());
    }

    public void enableMemTableFlushPending() {
        this.properties.add(RocksDBProperty.MemTableFlushPending.getRocksDBProperty());
    }

    public void enableCompactionPending() {
        this.properties.add(RocksDBProperty.CompactionPending.getRocksDBProperty());
    }

    public void enableBackgroundErrors() {
        this.properties.add(RocksDBProperty.BackgroundErrors.getRocksDBProperty());
    }

    public void enableCurSizeActiveMemTable() {
        this.properties.add(RocksDBProperty.CurSizeActiveMemTable.getRocksDBProperty());
    }

    public void enableCurSizeAllMemTables() {
        this.properties.add(RocksDBProperty.CurSizeAllMemTables.getRocksDBProperty());
    }

    public void enableSizeAllMemTables() {
        this.properties.add(RocksDBProperty.SizeAllMemTables.getRocksDBProperty());
    }

    public void enableNumEntriesActiveMemTable() {
        this.properties.add(RocksDBProperty.NumEntriesActiveMemTable.getRocksDBProperty());
    }

    public void enableNumEntriesImmMemTables() {
        this.properties.add(RocksDBProperty.NumEntriesImmMemTables.getRocksDBProperty());
    }

    public void enableNumDeletesActiveMemTable() {
        this.properties.add(RocksDBProperty.NumDeletesActiveMemTable.getRocksDBProperty());
    }

    public void enableNumDeletesImmMemTables() {
        this.properties.add(RocksDBProperty.NumDeletesImmMemTables.getRocksDBProperty());
    }

    public void enableEstimateNumKeys() {
        this.properties.add(RocksDBProperty.EstimateNumKeys.getRocksDBProperty());
    }

    public void enableEstimateTableReadersMem() {
        this.properties.add(RocksDBProperty.EstimateTableReadersMem.getRocksDBProperty());
    }

    public void enableNumSnapshots() {
        this.properties.add(RocksDBProperty.NumSnapshots.getRocksDBProperty());
    }

    public void enableNumLiveVersions() {
        this.properties.add(RocksDBProperty.NumLiveVersions.getRocksDBProperty());
    }

    public void enableEstimateLiveDataSize() {
        this.properties.add(RocksDBProperty.EstimateLiveDataSize.getRocksDBProperty());
    }

    public void enableTotalSstFilesSize() {
        this.properties.add(RocksDBProperty.TotalSstFilesSize.getRocksDBProperty());
    }

    public void enableEstimatePendingCompactionBytes() {
        this.properties.add(RocksDBProperty.EstimatePendingCompactionBytes.getRocksDBProperty());
    }

    public void enableNumRunningCompactions() {
        this.properties.add(RocksDBProperty.NumRunningCompactions.getRocksDBProperty());
    }

    public void enableNumRunningFlushes() {
        this.properties.add(RocksDBProperty.NumRunningFlushes.getRocksDBProperty());
    }

    public void enableActualDelayedWriteRate() {
        this.properties.add(RocksDBProperty.ActualDelayedWriteRate.getRocksDBProperty());
    }

    public Collection<String> getProperties() {
        return Collections.unmodifiableCollection(this.properties);
    }

    public boolean isEnabled() {
        return !this.properties.isEmpty();
    }
}

