/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.contrib.streaming.state.DefaultConfigurableOptionsFactory;
import org.apache.flink.contrib.streaming.state.PredefinedOptions;
import org.apache.flink.contrib.streaming.state.RocksDBStateBackend;

public class RocksDBOptions {
    public static final ConfigOption<String> LOCAL_DIRECTORIES = ConfigOptions.key((String)"state.backend.rocksdb.localdir").noDefaultValue().withDeprecatedKeys(new String[]{"state.backend.rocksdb.checkpointdir"}).withDescription("The local directory (on the TaskManager) where RocksDB puts its files.");
    public static final ConfigOption<String> TIMER_SERVICE_FACTORY = ConfigOptions.key((String)"state.backend.rocksdb.timer-service.factory").defaultValue((Object)RocksDBStateBackend.PriorityQueueStateType.HEAP.name()).withDescription(String.format("This determines the factory for timer service state implementation. Options are either %s (heap-based, default) or %s for an implementation based on RocksDB .", RocksDBStateBackend.PriorityQueueStateType.HEAP.name(), RocksDBStateBackend.PriorityQueueStateType.ROCKSDB.name()));
    public static final ConfigOption<Integer> CHECKPOINT_TRANSFER_THREAD_NUM = ConfigOptions.key((String)"state.backend.rocksdb.checkpoint.transfer.thread.num").defaultValue((Object)1).withDescription("The number of threads used to transfer (download and upload) files in RocksDBStateBackend.");
    public static final ConfigOption<Boolean> TTL_COMPACT_FILTER_ENABLED = ConfigOptions.key((String)"state.backend.rocksdb.ttl.compaction.filter.enabled").defaultValue((Object)false).withDescription("This determines if compaction filter to cleanup state with TTL is enabled for backend.Note: User can still decide in state TTL configuration in state descriptor whether the filter is active for particular state or not.");
    public static final ConfigOption<String> PREDEFINED_OPTIONS = ConfigOptions.key((String)"state.backend.rocksdb.predefined-options").defaultValue((Object)PredefinedOptions.DEFAULT.name()).withDescription(String.format("The predefined settings for RocksDB DBOptions and ColumnFamilyOptions by Flink community. Current supported candidate predefined-options are %s, %s, %s or %s. Note that user customized options and options from the OptionsFactory are applied on top of these predefined ones.", PredefinedOptions.DEFAULT.name(), PredefinedOptions.SPINNING_DISK_OPTIMIZED.name(), PredefinedOptions.SPINNING_DISK_OPTIMIZED_HIGH_MEM.name(), PredefinedOptions.FLASH_SSD_OPTIMIZED.name()));
    public static final ConfigOption<String> OPTIONS_FACTORY = ConfigOptions.key((String)"state.backend.rocksdb.options-factory").defaultValue((Object)DefaultConfigurableOptionsFactory.class.getName()).withDescription(String.format("The options factory class for RocksDB to create DBOptions and ColumnFamilyOptions. The default options factory is %s, and it would read the configured options which provided in 'RocksDBConfigurableOptions'.", DefaultConfigurableOptionsFactory.class.getName()));
}

