/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.util.Collection;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.contrib.streaming.state.AbstractRocksDBAppendingState;
import org.apache.flink.contrib.streaming.state.RocksDBKeyedStateBackend;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.RegisteredKeyValueStateBackendMetaInfo;
import org.apache.flink.runtime.state.internal.InternalReducingState;
import org.apache.flink.util.FlinkRuntimeException;
import org.rocksdb.ColumnFamilyHandle;

class RocksDBReducingState<K, N, V>
extends AbstractRocksDBAppendingState<K, N, V, V, V>
implements InternalReducingState<K, N, V> {
    private final ReduceFunction<V> reduceFunction;

    private RocksDBReducingState(ColumnFamilyHandle columnFamily, TypeSerializer<N> namespaceSerializer, TypeSerializer<V> valueSerializer, V defaultValue, ReduceFunction<V> reduceFunction, RocksDBKeyedStateBackend<K> backend) {
        super(columnFamily, namespaceSerializer, valueSerializer, defaultValue, backend);
        this.reduceFunction = reduceFunction;
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.backend.getKeySerializer();
    }

    public TypeSerializer<N> getNamespaceSerializer() {
        return this.namespaceSerializer;
    }

    public TypeSerializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public V get() {
        return (V)this.getInternal();
    }

    public void add(V value) throws Exception {
        byte[] key = this.getKeyBytes();
        Object oldValue = this.getInternal(key);
        V newValue = oldValue == null ? value : this.reduceFunction.reduce(oldValue, value);
        this.updateInternal(key, newValue);
    }

    public void mergeNamespaces(N target, Collection<N> sources) {
        if (sources == null || sources.isEmpty()) {
            return;
        }
        try {
            Object current = null;
            for (N source : sources) {
                if (source == null) continue;
                this.setCurrentNamespace(source);
                byte[] sourceKey = this.serializeCurrentKeyWithGroupAndNamespace();
                byte[] valueBytes = this.backend.db.get(this.columnFamily, sourceKey);
                this.backend.db.delete(this.columnFamily, this.writeOptions, sourceKey);
                if (valueBytes == null) continue;
                this.dataInputView.setBuffer(valueBytes);
                Object value = this.valueSerializer.deserialize((DataInputView)this.dataInputView);
                if (current != null) {
                    current = this.reduceFunction.reduce(current, value);
                    continue;
                }
                current = value;
            }
            if (current != null) {
                this.setCurrentNamespace(target);
                byte[] targetKey = this.serializeCurrentKeyWithGroupAndNamespace();
                byte[] targetValueBytes = this.backend.db.get(this.columnFamily, targetKey);
                if (targetValueBytes != null) {
                    this.dataInputView.setBuffer(targetValueBytes);
                    Object value = this.valueSerializer.deserialize((DataInputView)this.dataInputView);
                    current = this.reduceFunction.reduce(current, value);
                }
                this.dataOutputView.clear();
                this.valueSerializer.serialize(current, (DataOutputView)this.dataOutputView);
                this.backend.db.put(this.columnFamily, this.writeOptions, targetKey, this.dataOutputView.getCopyOfBuffer());
            }
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Error while merging state in RocksDB", (Throwable)e);
        }
    }

    static <K, N, SV, S extends State, IS extends S> IS create(StateDescriptor<S, SV> stateDesc, Tuple2<ColumnFamilyHandle, RegisteredKeyValueStateBackendMetaInfo<N, SV>> registerResult, RocksDBKeyedStateBackend<K> backend) {
        return (IS)new RocksDBReducingState<K, N, Object>((ColumnFamilyHandle)registerResult.f0, ((RegisteredKeyValueStateBackendMetaInfo)registerResult.f1).getNamespaceSerializer(), ((RegisteredKeyValueStateBackendMetaInfo)registerResult.f1).getStateSerializer(), stateDesc.getDefaultValue(), ((ReducingStateDescriptor)stateDesc).getReduceFunction(), backend);
    }
}

