/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.async.queue;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.functions.async.ResultFuture;
import org.apache.flink.streaming.api.operators.async.queue.AsyncCollectionResult;
import org.apache.flink.streaming.api.operators.async.queue.StreamElementQueueEntry;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

@Internal
public class StreamRecordQueueEntry<OUT>
extends StreamElementQueueEntry<Collection<OUT>>
implements AsyncCollectionResult<OUT>,
ResultFuture<OUT> {
    private final boolean hasTimestamp;
    private final long timestamp;
    private final CompletableFuture<Collection<OUT>> resultFuture;

    public StreamRecordQueueEntry(StreamRecord<?> streamRecord) {
        super(streamRecord);
        this.hasTimestamp = streamRecord.hasTimestamp();
        this.timestamp = streamRecord.getTimestamp();
        this.resultFuture = new CompletableFuture();
    }

    @Override
    public boolean hasTimestamp() {
        return this.hasTimestamp;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Collection<OUT> get() throws Exception {
        return this.resultFuture.get();
    }

    @Override
    protected CompletableFuture<Collection<OUT>> getFuture() {
        return this.resultFuture;
    }

    @Override
    public void complete(Collection<OUT> result) {
        this.resultFuture.complete(result);
    }

    @Override
    public void completeExceptionally(Throwable error) {
        this.resultFuture.completeExceptionally(error);
    }
}

