/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;

public class ExplainOperation
implements Operation {
    private final Operation child;
    private final Set<String> explainDetails;

    public ExplainOperation(Operation child) {
        this(child, new HashSet<String>());
    }

    public ExplainOperation(Operation child, Set<String> explainDetails) {
        this.child = child;
        this.explainDetails = explainDetails;
    }

    public Operation getChild() {
        return this.child;
    }

    @Override
    public String asSummaryString() {
        String operationName = "EXPLAIN";
        if (!this.explainDetails.isEmpty()) {
            operationName = String.format("EXPLAIN %s", this.explainDetails.stream().map(String::toUpperCase).collect(Collectors.joining(", ")));
        }
        return OperationUtils.formatWithChildren(operationName, Collections.emptyMap(), Collections.singletonList(this.child), Operation::asSummaryString);
    }

    public Set<String> getExplainDetails() {
        return this.explainDetails;
    }
}

