/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.stream;

import java.io.Serializable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.util.Pair;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.plan.nodes.FlinkRelNode;
import org.apache.flink.table.planner.plan.nodes.physical.FlinkPhysicalRel;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalRel;
import org.apache.flink.table.planner.plan.utils.RelExplainUtil$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc!B\u0001\u0003\u0003\u0003)\"aH*ue\u0016\fW\u000e\u00155zg&\u001c\u0017\r\\(wKJ\fum\u001a:fO\u0006$XMQ1tK*\u00111\u0001B\u0001\u0007gR\u0014X-Y7\u000b\u0005\u00151\u0011\u0001\u00039isNL7-\u00197\u000b\u0005\u001dA\u0011!\u00028pI\u0016\u001c(BA\u0005\u000b\u0003\u0011\u0001H.\u00198\u000b\u0005-a\u0011a\u00029mC:tWM\u001d\u0006\u0003\u001b9\tQ\u0001^1cY\u0016T!a\u0004\t\u0002\u000b\u0019d\u0017N\\6\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\u0002\u0001'\r\u0001aC\b\t\u0003/qi\u0011\u0001\u0007\u0006\u00033i\t1A]3m\u0015\tY\u0002#A\u0004dC2\u001c\u0017\u000e^3\n\u0005uA\"!C*j]\u001edWMU3m!\ty\u0002%D\u0001\u0003\u0013\t\t#AA\tTiJ,\u0017-\u001c)isNL7-\u00197SK2D\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\bG2,8\u000f^3s!\t)s%D\u0001'\u0015\tI!$\u0003\u0002)M\ti!+\u001a7PaR\u001cE.^:uKJD\u0001B\u000b\u0001\u0003\u0002\u0003\u0006IaK\u0001\tiJ\f\u0017\u000e^*fiB\u0011Q\u0005L\u0005\u0003[\u0019\u00121BU3m)J\f\u0017\u000e^*fi\"Aq\u0006\u0001B\u0001B\u0003%\u0001'\u0001\u0005j]B,HOU3m!\t9\u0012'\u0003\u000231\t9!+\u001a7O_\u0012,\u0007\u0002\u0003\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u001b\u0002\u001b=,H\u000f];u%><H+\u001f9f!\t1\u0014(D\u00018\u0015\tA\u0004$\u0001\u0003usB,\u0017B\u0001\u001e8\u0005-\u0011V\r\u001c#bi\u0006$\u0016\u0010]3\t\u0011q\u0002!\u0011!Q\u0001\nu\n1\u0002\\8hS\u000e<\u0016N\u001c3poB\u0011a(Q\u0007\u0002\u007f)\u0011\u0001\tG\u0001\u0005G>\u0014X-\u0003\u0002C\u007f\t1q+\u001b8e_^DQ\u0001\u0012\u0001\u0005\u0002\u0015\u000ba\u0001P5oSRtDC\u0002$H\u0011&S5\n\u0005\u0002 \u0001!)1e\u0011a\u0001I!)!f\u0011a\u0001W!)qf\u0011a\u0001a!)Ag\u0011a\u0001k!)Ah\u0011a\u0001{!)Q\n\u0001C!\u001d\u0006\u0001\"/Z9vSJ,w+\u0019;fe6\f'o[\u000b\u0002\u001fB\u0011\u0001kU\u0007\u0002#*\t!+A\u0003tG\u0006d\u0017-\u0003\u0002U#\n9!i\\8mK\u0006t\u0007\"\u0002,\u0001\t\u0003:\u0016!\u00043fe&4XMU8x)f\u0004X\rF\u00016\u0011\u0015I\u0006\u0001\"\u0011[\u0003A)7\u000f^5nCR,'k\\<D_VtG\u000f\u0006\u0002\\=B\u0011\u0001\u000bX\u0005\u0003;F\u0013a\u0001R8vE2,\u0007\"B0Y\u0001\u0004\u0001\u0017AA7r!\t\tG-D\u0001c\u0015\t\u0019\u0007$\u0001\u0005nKR\fG-\u0019;b\u0013\t)'M\u0001\tSK2lU\r^1eCR\f\u0017+^3ss\")q\r\u0001C!Q\u0006y1m\\7qkR,7+\u001a7g\u0007>\u001cH\u000fF\u0002jYB\u0004\"!\n6\n\u0005-4#A\u0003*fY>\u0003HoQ8ti\")1B\u001aa\u0001[B\u0011QE\\\u0005\u0003_\u001a\u0012QBU3m\u001fB$\b\u000b\\1o]\u0016\u0014\b\"B0g\u0001\u0004\u0001\u0007\"\u0002:\u0001\t\u0003\u001a\u0018\u0001D3ya2\f\u0017N\u001c+fe6\u001cHC\u0001;x!\t9R/\u0003\u0002w1\tI!+\u001a7Xe&$XM\u001d\u0005\u0006qF\u0004\r\u0001^\u0001\u0003a^DQA\u001f\u0001\u0005\nm\fqcZ3oKJ\fG/\u001a(b[\u0016$\u0017iZ4sK\u001e\fG/Z:\u0016\u0003q\u0004R!`A\u0006\u0003#q1A`A\u0004\u001d\ry\u0018QA\u0007\u0003\u0003\u0003Q1!a\u0001\u0015\u0003\u0019a$o\\8u}%\t!+C\u0002\u0002\nE\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u000e\u0005=!aA*fc*\u0019\u0011\u0011B)\u0011\u0011\u0005M\u00111FA\u0019\u0003oqA!!\u0006\u0002*9!\u0011qCA\u0014\u001d\u0011\tI\"!\n\u000f\t\u0005m\u00111\u0005\b\u0005\u0003;\t\tCD\u0002\u0000\u0003?I\u0011aE\u0005\u0003#II!a\u0004\t\n\u00055q\u0011BA\u0006\r\u0013\r\tIAC\u0005\u0005\u0003[\tyCA\u0006DC2\u001c\u0017\u000e^3QC&\u0014(bAA\u0005\u0015A\u0019a(a\r\n\u0007\u0005UrHA\u0007BO\u001e\u0014XmZ1uK\u000e\u000bG\u000e\u001c\t\u0005\u0003s\t\tE\u0004\u0003\u0002<\u0005u\u0002CA@R\u0013\r\ty$U\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0013Q\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005}\u0012\u000b")
public abstract class StreamPhysicalOverAggregateBase
extends SingleRel
implements StreamPhysicalRel {
    private final RelNode inputRel;
    private final RelDataType outputRowType;
    private final Window logicWindow;

    @Override
    public Option<RelNode> satisfyTraits(RelTraitSet requiredTraitSet) {
        return FlinkPhysicalRel.satisfyTraits$(this, requiredTraitSet);
    }

    @Override
    public String getRelDetailedDescription() {
        return FlinkRelNode.getRelDetailedDescription$(this);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable, SqlExplainLevel sqlExplainLevel) {
        return FlinkRelNode.getExpressionString$((FlinkRelNode)this, expr, inFields, localExprsTable, sqlExplainLevel);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable, Enumeration.Value expressionDetail) {
        return FlinkRelNode.getExpressionString$((FlinkRelNode)this, expr, inFields, localExprsTable, expressionDetail);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable, Enumeration.Value expressionFormat, SqlExplainLevel sqlExplainLevel) {
        return FlinkRelNode.getExpressionString$((FlinkRelNode)this, expr, inFields, localExprsTable, expressionFormat, sqlExplainLevel);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable, Enumeration.Value expressionFormat, Enumeration.Value expressionDetail) {
        return FlinkRelNode.getExpressionString$((FlinkRelNode)this, expr, inFields, localExprsTable, expressionFormat, expressionDetail);
    }

    @Override
    public Enumeration.Value convertToExpressionDetail(SqlExplainLevel sqlExplainLevel) {
        return FlinkRelNode.convertToExpressionDetail$(this, sqlExplainLevel);
    }

    @Override
    public boolean requireWatermark() {
        if (this.logicWindow.groups.size() != 1 || ((Window.Group)this.logicWindow.groups.get((int)0)).orderKeys.getFieldCollations().size() != 1) {
            return false;
        }
        RelFieldCollation orderKey = ((Window.Group)this.logicWindow.groups.get((int)0)).orderKeys.getFieldCollations().get(0);
        RelDataType timeType = this.outputRowType.getFieldList().get(orderKey.getFieldIndex()).getType();
        return FlinkTypeFactory$.MODULE$.isRowtimeIndicatorType(timeType);
    }

    @Override
    public RelDataType deriveRowType() {
        return this.outputRowType;
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        return Predef$.MODULE$.Double2double(mq.getRowCount(this.getInput()));
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCnt = Predef$.MODULE$.Double2double(mq.getRowCount(this));
        double count = (double)(this.getRowType().getFieldCount() - 1) * 1.0 / (double)this.inputRel.getRowType().getFieldCount();
        return planner.getCostFactory().makeCost(rowCnt, rowCnt * count, 0.0);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        Window.Group overWindow = (Window.Group)this.logicWindow.groups.get(0);
        Seq constants = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.logicWindow.constants).asScala();
        int[] partitionKeys = overWindow.keys.toArray();
        Seq<Pair<AggregateCall, String>> namedAggregates = this.generateNamedAggregates();
        RelDataType inputRowType = this.getInput().getRowType();
        return super.explainTerms(pw).itemIf("partitionBy", RelExplainUtil$.MODULE$.fieldToString(partitionKeys, inputRowType), new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partitionKeys)).nonEmpty()).item("orderBy", RelExplainUtil$.MODULE$.collationToString(overWindow.orderKeys, inputRowType)).item("window", RelExplainUtil$.MODULE$.windowRangeToString(this.logicWindow, overWindow)).item("select", RelExplainUtil$.MODULE$.overAggregationToString(inputRowType, this.outputRowType, (Seq<RexLiteral>)constants, namedAggregates, RelExplainUtil$.MODULE$.overAggregationToString$default$5(), RelExplainUtil$.MODULE$.overAggregationToString$default$6()));
    }

    private Seq<Pair<AggregateCall, String>> generateNamedAggregates() {
        Window.Group overWindow = (Window.Group)this.logicWindow.groups.get(0);
        java.util.List<AggregateCall> aggregateCalls = overWindow.getAggregateCalls(this.logicWindow);
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), aggregateCalls.size()).map((Function1 & Serializable & scala.Serializable)i -> StreamPhysicalOverAggregateBase.$anonfun$generateNamedAggregates$1(aggregateCalls, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Pair $anonfun$generateNamedAggregates$1(java.util.List aggregateCalls$1, int i) {
        return new Pair(aggregateCalls$1.get(i), new StringBuilder(4).append("w0$o").append(i).toString());
    }

    public StreamPhysicalOverAggregateBase(RelOptCluster cluster, RelTraitSet traitSet, RelNode inputRel, RelDataType outputRowType, Window logicWindow) {
        this.inputRel = inputRel;
        this.outputRowType = outputRowType;
        this.logicWindow = logicWindow;
        super(cluster, traitSet, inputRel);
        FlinkRelNode.$init$(this);
        FlinkPhysicalRel.$init$(this);
    }
}

