/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.alias;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.table.planner.hint.JoinStrategy;

public class ClearJoinHintWithInvalidPropagationShuttle
extends RelShuttleImpl {
    @Override
    public RelNode visit(LogicalJoin join) {
        ImmutableList<RelHint> hints = join.getHints();
        Set allHintNames = hints.stream().map(hint -> hint.hintName).collect(Collectors.toSet());
        if (allHintNames.stream().noneMatch(JoinStrategy::isJoinStrategy)) {
            return super.visit(join);
        }
        Optional<RelHint> firstAliasHint = hints.stream().filter(hint -> "ALIAS".equals(hint.hintName)).findFirst();
        if (!firstAliasHint.isPresent()) {
            return super.visit(join);
        }
        List joinHintsFromOuterQueryBlock = hints.stream().filter(hint -> JoinStrategy.isJoinStrategy(hint.hintName) && hint.inheritPath.size() > ((RelHint)firstAliasHint.get()).inheritPath.size()).collect(Collectors.toList());
        if (joinHintsFromOuterQueryBlock.isEmpty()) {
            return super.visit(join);
        }
        RelNode newJoin = join;
        for (RelHint outerJoinHint : joinHintsFromOuterQueryBlock) {
            ClearOuterJoinHintShuttle clearOuterJoinHintShuttle = new ClearOuterJoinHintShuttle(outerJoinHint);
            newJoin = newJoin.accept(clearOuterJoinHintShuttle);
        }
        return super.visit(newJoin);
    }

    private static class ClearOuterJoinHintShuttle
    extends RelShuttleImpl {
        private final Deque<Integer> currentInheritPath;
        private final RelHint joinHintNeedRemove;

        public ClearOuterJoinHintShuttle(RelHint joinHintNeedRemove) {
            this.joinHintNeedRemove = joinHintNeedRemove;
            this.currentInheritPath = new ArrayDeque<Integer>();
            this.currentInheritPath.addAll(joinHintNeedRemove.inheritPath);
        }

        @Override
        protected RelNode visitChild(RelNode parent, int i, RelNode child) {
            this.currentInheritPath.addLast(i);
            RelNode newNode = super.visitChild(parent, i, child);
            this.currentInheritPath.removeLast();
            return newNode;
        }

        @Override
        public RelNode visit(LogicalJoin join) {
            ArrayList<RelHint> hints = new ArrayList<RelHint>(join.getHints());
            Optional<RelHint> invalidJoinHint = this.getInvalidJoinHint(hints);
            if (invalidJoinHint.isPresent()) {
                hints.remove(invalidJoinHint.get());
                return super.visit(join.withHints(hints));
            }
            return super.visit(join);
        }

        private Optional<RelHint> getInvalidJoinHint(List<RelHint> hints) {
            for (RelHint hint : hints) {
                if (!hint.hintName.equals(this.joinHintNeedRemove.hintName) || !this.isMatchInvalidInheritPath(new ArrayList<Integer>(this.currentInheritPath), hint.inheritPath)) continue;
                return Optional.of(hint);
            }
            return Optional.empty();
        }

        private boolean isMatchInvalidInheritPath(List<Integer> invalidInheritPath, List<Integer> checkedInheritPath) {
            if (invalidInheritPath.size() != checkedInheritPath.size()) {
                return false;
            }
            for (int i = 0; i < invalidInheritPath.size(); ++i) {
                if (Objects.equals(invalidInheritPath.get(i), checkedInheritPath.get(i))) continue;
                return false;
            }
            return true;
        }
    }
}

